/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;

public class JupiterRenderContext {
    private final PoseStack pose;
    private final MultiBufferSource.BufferSource bufferSource;

    private JupiterRenderContext(PoseStack pose, MultiBufferSource.BufferSource bufferSource) {
        this.pose = pose;
        this.bufferSource = bufferSource;
    }

    public static JupiterRenderContext wrapPoseStack(PoseStack poseStack) {
        Minecraft minecraft = Minecraft.getInstance();
        return new JupiterRenderContext(poseStack, minecraft.renderBuffers().bufferSource());
    }

    public void flush() {
        RenderSystem.disableDepthTest();
        this.bufferSource.endBatch();
        RenderSystem.enableDepthTest();
    }

    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.fill(minX, minY, maxX, maxY, 0, color);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int z, int color) {
        this.fill(RenderType.lightning(), minX, minY, maxX, maxY, z, color);
    }

    public void fill(RenderType renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        Matrix4f matrix4f = this.pose.last().pose();
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
        float f = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float f1 = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float f2 = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        VertexConsumer consumer = this.bufferSource.getBuffer(renderType);
        consumer.vertex(matrix4f, (float)minX, (float)minY, (float)z).color(f, f1, f2, f3).endVertex();
        consumer.vertex(matrix4f, (float)minX, (float)maxY, (float)z).color(f, f1, f2, f3).endVertex();
        consumer.vertex(matrix4f, (float)maxX, (float)maxY, (float)z).color(f, f1, f2, f3).endVertex();
        consumer.vertex(matrix4f, (float)maxX, (float)minY, (float)z).color(f, f1, f2, f3).endVertex();
        this.flush();
    }

    public void drawCenteredString(Font font, Component text, int x, int y, int color) {
        this.drawString(font, text, x - font.width((FormattedText)text) / 2, y, color);
    }

    public void drawString(Font font, @NotNull String text, int x, int y, int color) {
        font.drawShadow(this.pose, text, (float)x, (float)y, color);
        this.flush();
    }

    public void drawString(Font font, Component text, int x, int y, int color) {
        font.drawShadow(this.pose, text, (float)x, (float)y, color);
        this.flush();
    }
}

