/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FakeConfigContainer;
import com.iafenvoy.jupiter.config.container.FileConfigContainer;
import com.iafenvoy.jupiter.network.ClientConfigNetwork;
import com.iafenvoy.jupiter.render.JupiterRenderContext;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.widget.SimpleButtonTooltip;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ConfigSelectScreen<S extends FileConfigContainer, C extends FileConfigContainer>
extends Screen
implements JupiterScreen {
    private final Screen parent;
    private final S serverConfig;
    @Nullable
    private final C clientConfig;
    @Nullable
    private FakeConfigContainer fakeServerConfig;

    public ConfigSelectScreen(Component title, Screen parent, S serverConfig, @Nullable C clientConfig) {
        super(title);
        this.parent = parent;
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
    }

    protected void init() {
        super.init();
        int x = this.width / 2;
        int y = this.height / 2;
        this.addRenderableWidget((GuiEventListener)JupiterScreen.createButton(x - 100, y - 25 - 10, 200, 20, (Component)TextUtil.translatable("jupiter.screen.back", new Object[0]), button -> {
            assert (this.minecraft != null);
            this.minecraft.setScreen(this.parent);
        }));
        SimpleButtonTooltip serverButtonTooltip = new SimpleButtonTooltip(this, (Component)TextUtil.translatable("jupiter.screen.check_server", new Object[0]));
        Button serverButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(x - 100, y - 10, 200, 20, (Component)TextUtil.translatable("jupiter.screen.server_config", new Object[0]), button -> {
            assert (this.minecraft != null);
            assert (this.serverConfig != null);
            this.minecraft.setScreen(JupiterScreen.getConfigScreen(this, this.getServerConfig(), false));
        }, (Button.OnTooltip)serverButtonTooltip));
        Button clientButton = (Button)this.addRenderableWidget((GuiEventListener)JupiterScreen.createButton(this, x - 100, y + 25 - 10, 200, 20, (Component)TextUtil.translatable("jupiter.screen.client_config", new Object[0]), button -> {
            assert (this.minecraft != null);
            assert (this.clientConfig != null);
            this.minecraft.setScreen(JupiterScreen.getConfigScreen(this, this.clientConfig, true));
        }, (Component)TextUtil.translatable(this.clientConfig != null ? "jupiter.screen.open_client" : "jupiter.screen.disable_client", new Object[0])));
        serverButton.active = true;
        boolean bl = clientButton.active = this.clientConfig != null;
        if (JupiterScreen.connectedToDedicatedServer()) {
            this.fakeServerConfig = new FakeConfigContainer((AbstractConfigContainer)this.serverConfig);
            serverButton.active = false;
            ClientConfigNetwork.syncConfig(((AbstractConfigContainer)this.serverConfig).getConfigId(), nbt -> {
                if (nbt == null) {
                    serverButtonTooltip.setTooltip((Component)TextUtil.translatable("jupiter.screen.disable_server", new Object[0]));
                } else {
                    try {
                        assert (this.fakeServerConfig != null);
                        this.fakeServerConfig.deserializeNbt((CompoundTag)nbt);
                        serverButtonTooltip.setTooltip((Component)TextUtil.translatable("jupiter.screen.open_server", new Object[0]));
                        serverButton.active = true;
                    }
                    catch (Exception e) {
                        Jupiter.LOGGER.error("Failed to parse server config data from server: {}", (Object)((AbstractConfigContainer)this.serverConfig).getConfigId(), (Object)e);
                        serverButtonTooltip.setTooltip((Component)TextUtil.translatable("jupiter.screen.error_server", new Object[0]));
                    }
                }
            });
        } else {
            serverButtonTooltip.setTooltip((Component)TextUtil.translatable("jupiter.screen.open_server", new Object[0]));
        }
    }

    public void render(PoseStack graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics);
        assert (this.minecraft != null);
        JupiterRenderContext context = JupiterRenderContext.wrapPoseStack(graphics);
        context.drawCenteredString(this.minecraft.font, this.title, this.width / 2, this.height / 2 - 50, -1);
        super.render(graphics, mouseX, mouseY, delta);
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return true;
    }

    private AbstractConfigContainer getServerConfig() {
        if (!JupiterScreen.connectedToDedicatedServer()) {
            return this.serverConfig;
        }
        assert (this.fakeServerConfig != null);
        return this.fakeServerConfig;
    }
}

