/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.Platform;
import com.iafenvoy.jupiter.config.entry.EntryBaseEntry;
import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.widget.StringWidget;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.ButtonWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.ConfigGroupWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.EntryWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.ListWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.MapWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.SeparatorWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.TextFieldWidgetBuilder;
import com.iafenvoy.jupiter.util.EnumHelper;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class WidgetBuilderManager {
    private static final Map<ConfigType<?>, BiFunction<ConfigMetaProvider, IConfigEntry<?>, WidgetBuilder<?>>> BUILDERS = new HashMap();

    public static <T> void register(ConfigType<T> type, BiFunction<ConfigMetaProvider, IConfigEntry<T>, WidgetBuilder<T>> builder) {
        BUILDERS.put(type, builder);
    }

    public static <T> WidgetBuilder<T> get(ConfigMetaProvider provider, IConfigEntry<T> entry) {
        return BUILDERS.getOrDefault(entry.getType(), Fallback::new).apply(provider, entry);
    }

    static {
        WidgetBuilderManager.register(ConfigTypes.SEPARATOR, SeparatorWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.CONFIG_GROUP, ConfigGroupWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.BOOLEAN, (provider, config) -> new ButtonWidgetBuilder((ConfigMetaProvider)provider, config, button -> config.setValue((Boolean)config.getValue() == false), () -> TextUtil.literal((Boolean)config.getValue() != false ? "\u00a7atrue" : "\u00a7cfalse")));
        WidgetBuilderManager.register(ConfigTypes.INTEGER, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.LONG, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.DOUBLE, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.STRING, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.ENUM, (provider, config) -> new ButtonWidgetBuilder((ConfigMetaProvider)provider, config, button -> config.setValue(EnumHelper.cycle((Enum)config.getValue(), true)), () -> EnumHelper.getDisplayText((Enum)config.getValue())));
        WidgetBuilderManager.register(ConfigTypes.LIST_BOOLEAN, (provider, config) -> new ListWidgetBuilder((ConfigMetaProvider)provider, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_INTEGER, (provider, config) -> new ListWidgetBuilder((ConfigMetaProvider)provider, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_LONG, (provider, config) -> new ListWidgetBuilder((ConfigMetaProvider)provider, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_DOUBLE, (provider, config) -> new ListWidgetBuilder((ConfigMetaProvider)provider, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_STRING, (provider, config) -> new ListWidgetBuilder((ConfigMetaProvider)provider, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_ENUM, (provider, config) -> new ListWidgetBuilder((ConfigMetaProvider)provider, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_STRING, (provider, config) -> new MapWidgetBuilder((ConfigMetaProvider)provider, (MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_INTEGER, (provider, config) -> new MapWidgetBuilder((ConfigMetaProvider)provider, (MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_DOUBLE, (provider, config) -> new MapWidgetBuilder((ConfigMetaProvider)provider, (MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_STRING, (provider, config) -> new EntryWidgetBuilder((ConfigMetaProvider)provider, (EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_INTEGER, (provider, config) -> new EntryWidgetBuilder((ConfigMetaProvider)provider, (EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_DOUBLE, (provider, config) -> new EntryWidgetBuilder((ConfigMetaProvider)provider, (EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.RESOURCE_LOCATION, TextFieldWidgetBuilder::new);
    }

    private static class Fallback<T>
    extends WidgetBuilder<T> {
        public Fallback(ConfigMetaProvider configMetaProvider, IConfigEntry<T> config) {
            super(configMetaProvider, config);
        }

        @Override
        public void addElements(WidgetBuilder.Context context, int x, int y, int width, int height) {
            Font textRenderer = this.minecraft.font;
            MutableComponent text = TextUtil.translatable("jupiter.screen.unregistered_widget", this.config.getClass().getSimpleName(), this.provider.getSource().jupiterCapability() ? "Jupiter" : Platform.resolveModName(this.provider.getConfigId().getNamespace()));
            this.textWidget = new StringWidget(20, y, textRenderer.width((FormattedText)text), height, (Component)text, textRenderer);
            context.addWidget(this.textWidget);
        }

        @Override
        public void addCustomElements(WidgetBuilder.Context context, int x, int y, int width, int height) {
        }

        @Override
        public void updateCustom(boolean visible, int y) {
        }

        @Override
        public void refresh() {
        }
    }
}

