/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ButtonWidgetBuilder<T>
extends WidgetBuilder<T> {
    private final Button.OnPress action = button -> {
        action.onPress(button);
        this.refresh();
    };
    private final Supplier<Component> nameSupplier;
    @Nullable
    private Button button;

    public ButtonWidgetBuilder(ConfigMetaProvider provider, IConfigEntry<T> config, Button.OnPress action, Supplier<Component> nameSupplier) {
        super(provider, config);
        this.nameSupplier = nameSupplier;
    }

    @Override
    public void addCustomElements(WidgetBuilder.Context context, int x, int y, int width, int height) {
        this.button = JupiterScreen.createButton(x, y, width, height, this.nameSupplier.get(), this.action);
        context.addWidget((AbstractWidget)this.button);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.button == null) {
            return;
        }
        this.button.visible = visible;
        this.button.y = y;
    }

    @Override
    public void refresh() {
        if (this.button == null) {
            return;
        }
        this.button.setMessage(this.nameSupplier.get());
    }
}

