/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.container;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.ConfigDataFixer;
import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.entry.IntegerEntry;
import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public abstract class AbstractConfigContainer
implements ConfigMetaProvider {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final List<ConfigGroup> configTabs = new ArrayList<ConfigGroup>();
    protected final ResourceLocation id;
    protected final Component title;
    protected final IntegerEntry version;
    protected final ConfigDataFixer dataFixer = new ConfigDataFixer();
    private Codec<List<ConfigGroup>> cache;

    public AbstractConfigContainer(ResourceLocation id, Component title) {
        this(id, title, 0);
    }

    public AbstractConfigContainer(ResourceLocation id, Component title, int version) {
        this.id = id;
        this.title = title;
        this.version = (IntegerEntry)IntegerEntry.builder("version", version).build();
    }

    @Override
    public ResourceLocation getConfigId() {
        return this.id;
    }

    public Component getTitle() {
        return this.title;
    }

    public ConfigGroup createTab(String id, String translateKey) {
        return this.createTab(id, (Component)TextUtil.translatable(translateKey, new Object[0]));
    }

    public ConfigGroup createTab(String id, Component name) {
        ConfigGroup category = new ConfigGroup(id, name, new ArrayList());
        this.configTabs.add(category);
        this.cache = null;
        return category;
    }

    public List<ConfigGroup> getConfigTabs() {
        return this.configTabs;
    }

    public final void onConfigsChanged() {
        this.save();
        this.load();
    }

    public abstract void init();

    public abstract void load();

    public abstract void save();

    public String serialize() {
        JsonElement element;
        if (this.cache == null) {
            this.cache = this.buildCodec();
        }
        if ((element = (JsonElement)this.cache.encodeStart((DynamicOps)JsonOps.INSTANCE, this.configTabs).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).orElseThrow()) instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            this.writeCustomData(obj);
        }
        return GSON.toJson(element);
    }

    @Comment(value="For Network Usage Only")
    public CompoundTag serializeNbt() {
        if (this.cache == null) {
            this.cache = this.buildCodec();
        }
        return (CompoundTag)this.cache.encodeStart((DynamicOps)NbtOps.INSTANCE, this.configTabs).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).orElseThrow();
    }

    public void deserialize(String data) {
        JsonElement element = JsonParser.parseString((String)data);
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            if (!this.shouldLoad(obj)) {
                return;
            }
            this.deserializeJson((JsonElement)obj);
            this.readCustomData(obj);
        }
    }

    public final void deserializeJson(JsonElement element) {
        if (this.cache == null) {
            this.cache = this.buildCodec();
        }
        this.cache.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
    }

    @Comment(value="For Network Usage Only")
    public final void deserializeNbt(CompoundTag element) {
        if (element == null) {
            return;
        }
        if (this.cache == null) {
            this.cache = this.buildCodec();
        }
        this.cache.parse((DynamicOps)NbtOps.INSTANCE, (Object)element);
    }

    protected Codec<List<ConfigGroup>> buildCodec() {
        return MapCodec.of((MapEncoder)new MapEncoder.Implementation<List<ConfigGroup>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return AbstractConfigContainer.this.configTabs.stream().map(ConfigGroup::getId).map(arg_0 -> ops.createString(arg_0));
            }

            public <T> RecordBuilder<T> encode(List<ConfigGroup> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return input.stream().reduce(prefix, (p, c) -> p.add(c.getId(), c.encode(ops)), (a, b) -> null);
            }
        }, (MapDecoder)new MapDecoder.Implementation<List<ConfigGroup>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return AbstractConfigContainer.this.configTabs.stream().map(ConfigGroup::getId).map(arg_0 -> ops.createString(arg_0));
            }

            public <T> DataResult<List<ConfigGroup>> decode(DynamicOps<T> ops, MapLike<T> input) {
                input.entries().forEach(x -> {
                    String s = (String)ops.getStringValue(x.getFirst()).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).orElseThrow();
                    AbstractConfigContainer.this.configTabs.stream().filter(y -> y.getId().equals(s)).findFirst().ifPresent(y -> y.decode(ops, x.getSecond()));
                });
                return DataResult.success(AbstractConfigContainer.this.configTabs);
            }
        }).codec();
    }

    @Comment(value="Only call on saving to disk, not on network")
    protected boolean shouldLoad(JsonObject obj) {
        return true;
    }

    @Comment(value="Only call on saving to disk, not on network")
    protected void readCustomData(JsonObject obj) {
    }

    @Comment(value="Only call on saving to disk, not on network")
    protected void writeCustomData(JsonObject obj) {
    }
}

