/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.EnumEntry;
import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.EnumHelper;
import com.mojang.serialization.Codec;
import java.util.List;

public class ListEnumEntry<T extends Enum<T>>
extends ListBaseEntry<T> {
    private final T example;

    public ListEnumEntry(String nameKey, List<T> defaultValue, T example) {
        super(nameKey, defaultValue);
        this.example = example;
    }

    @Override
    public Codec<T> getValueCodec() {
        return EnumHelper.getCodec(this.example);
    }

    @Override
    public IConfigEntry<T> newSingleInstance(T value, final int index, final Runnable reload) {
        return new EnumEntry<T>(this.nameKey, (Enum)value){

            @Override
            public void reset() {
                ((List)ListEnumEntry.this.getValue()).remove(index);
                reload.run();
            }

            @Override
            public void setValue(T value) {
                super.setValue(value);
                ((List)ListEnumEntry.this.getValue()).set(index, value);
            }
        };
    }

    @Override
    public T newValue() {
        return this.example;
    }

    @Override
    public ConfigType<List<T>> getType() {
        return ConfigTypes.LIST_ENUM;
    }

    @Override
    public IConfigEntry<List<T>> newInstance() {
        return new ListEnumEntry<T>(this.nameKey, (List)this.defaultValue, this.example).visible(this.visible).json(this.jsonKey);
    }
}

