/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.compat.forgeconfigspec.ConfigSpecLoader;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FakeConfigContainer;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListWidget;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class JupiterConfigListScreen
extends Screen
implements JupiterScreen {
    private final Screen parent;
    private JupiterConfigListWidget widget;
    private Button openConfigButton = null;
    private boolean initialized = false;

    public JupiterConfigListScreen(Screen parent) {
        super((Component)TextUtil.translatable("jupiter.screen.config_list.title", new Object[0]));
        this.parent = parent;
        ConfigSpecLoader.scanConfig();
    }

    protected void init() {
        super.init();
        if (!this.initialized) {
            this.initialized = true;
            this.widget = new JupiterConfigListWidget(this, this.minecraft, this.width - 80, this.height - 80, 60);
        }
        this.widget.setSize(this.width - 80, this.height - 70);
        this.widget.setX(40);
        this.widget.update();
        this.addRenderableWidget((GuiEventListener)this.widget);
        this.addRenderableWidget((GuiEventListener)JupiterScreen.createButton(40, 25, 60, 20, (Component)TextUtil.translatable("jupiter.screen.back", new Object[0]), button -> this.onClose()));
        ((EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, 105, 25, this.width - 230, 20, (Component)TextUtil.empty()))).setResponder(this.widget::setFilter);
        this.openConfigButton = (Button)this.addRenderableWidget((GuiEventListener)JupiterScreen.createButton(this.width - 120, 25, 80, 20, (Component)TextUtil.translatable("jupiter.screen.open", new Object[0]), button -> {
            JupiterConfigListWidget.ConfigEntry handler = (JupiterConfigListWidget.ConfigEntry)this.widget.getSelected();
            if (this.minecraft != null && handler != null) {
                AbstractConfigContainer container = handler.getConfigContainer();
                boolean server = ServerConfigManager.getServerConfigs().contains(container);
                this.minecraft.setScreen(JupiterScreen.getConfigScreen(this, server ? this.getServerConfig(container) : container, !server));
            }
        }));
        this.setOpenConfigState(this.widget.getSelected() != null);
    }

    public void setOpenConfigState(boolean active) {
        if (this.openConfigButton != null) {
            this.openConfigButton.active = active;
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.widget.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
    }

    public void select(JupiterConfigListWidget.ConfigEntry entry) {
        this.widget.setSelected(entry);
    }

    public void onClose() {
        super.onClose();
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    private AbstractConfigContainer getServerConfig(AbstractConfigContainer container) {
        return JupiterScreen.connectedToDedicatedServer() ? new FakeConfigContainer(container) : container;
    }
}

