/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen.dialog;

import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.dialog.Dialog;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ListDialog<T>
extends Dialog<List<T>> {
    protected final ListBaseEntry<T> entry;
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    protected final List<WidgetBuilder<T>> widgets = new ArrayList<WidgetBuilder<T>>();
    private int configPerPage;

    public ListDialog(Screen parent, TitleStack titleStack, ConfigMetaProvider provider, ListBaseEntry<T> entry) {
        super(parent, titleStack, provider, entry);
        this.entry = entry;
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)JupiterScreen.createButton(10, 5, 20, 20, (Component)TextUtil.literal("<"), button -> this.onClose()));
        this.addRenderableWidget((GuiEventListener)JupiterScreen.createButton(this.width - 80, 5, 20, 20, (Component)TextUtil.literal("+"), button -> {
            ((List)this.entry.getValue()).add(this.entry.newValue());
            this.rebuildWidgets();
        }));
        this.calculateMaxItems();
        this.widgets.clear();
        List values = (List)this.entry.getValue();
        for (int i = 0; i < values.size(); ++i) {
            WidgetBuilder<T> widget = WidgetBuilderManager.get(this.provider, this.entry.newSingleInstance(values.get(i), i, () -> this.rebuildWidgets()));
            this.widgets.add(widget);
            widget.addDialogElements(new WidgetBuilder.Context(this, x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            }, this.titleStack), i + ":", 40, 0, Math.max(10, this.width - 70), 20);
        }
        this.updateItemPos();
    }

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.height - 30) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, ((List)this.entry.getValue()).size() - this.configPerPage));
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        List entries = (List)this.entry.getValue();
        for (i = 0; i < top && i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < entries.size(); ++i) {
            this.widgets.get(i).update(true, 30 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (scrollY > 0.0 ? -1 : 1) * 2);
        this.updateItemPos();
        return true;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.itemScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.width - 18, 30, 8, this.height - 50, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        int button = event.button();
        if (button == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.mouseClicked(event, isDoubleClick);
        if (!b) {
            this.setFocused(null);
        }
        return b;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        int button = event.button();
        if (button == 0) {
            this.itemScrollBar.setIsDragging(false);
        }
        return super.mouseReleased(event);
    }
}

