/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class WidgetBuilder<T> {
    protected static final Supplier<Minecraft> CLIENT = Minecraft::getInstance;
    protected final AbstractConfigContainer container;
    protected final IConfigEntry<T> config;
    protected StringWidget textWidget;
    protected Button resetButton;
    protected boolean canSave = true;

    protected WidgetBuilder(AbstractConfigContainer container, IConfigEntry<T> config) {
        this.container = container;
        this.config = config;
    }

    public void addDialogElements(Consumer<AbstractWidget> appender, String text, int x, int y, int width, int height) {
        Font font = WidgetBuilder.CLIENT.get().font;
        this.textWidget = new StringWidget(20, y, font.width(text), height, TextUtil.literal(text), font);
        appender.accept((AbstractWidget)this.textWidget);
        this.resetButton = Button.builder((Component)TextUtil.translatable("jupiter.screen.button.remove", new Object[0]), button -> {
            this.config.reset();
            this.refresh();
        }).bounds(x + width - 50, y, 50, height).build();
        this.refreshResetButton(true);
        appender.accept((AbstractWidget)this.resetButton);
        this.addCustomElements(appender, x, y, width - 55, height);
    }

    public void addElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
        Font font = WidgetBuilder.CLIENT.get().font;
        Component component = TextUtil.literal(this.config.getPrettyName());
        this.textWidget = new StringWidget(20, y, font.width((FormattedText)component), height, component, font);
        appender.accept((AbstractWidget)this.textWidget);
        this.resetButton = Button.builder((Component)TextUtil.translatable("jupiter.screen.button.reset", new Object[0]), button -> {
            this.config.reset();
            this.refresh();
        }).bounds(x + width - 50, y, 50, height).build();
        this.refreshResetButton(false);
        this.config.registerCallback(v -> this.refreshResetButton(false));
        appender.accept((AbstractWidget)this.resetButton);
        this.addCustomElements(appender, x, y, width - 55, height);
    }

    private void refreshResetButton(boolean dialog) {
        this.setCanReset(dialog || !this.config.getValue().equals(this.config.getDefaultValue()));
    }

    protected void setCanReset(boolean b) {
        this.resetButton.active = b;
    }

    public abstract void addCustomElements(Consumer<AbstractWidget> var1, int var2, int var3, int var4, int var5);

    public void update(boolean visible, int y) {
        if (this.textWidget != null) {
            this.textWidget.visible = visible;
            this.textWidget.setY(y);
        }
        if (this.resetButton != null) {
            this.resetButton.visible = visible;
            this.resetButton.setY(y);
        }
        this.updateCustom(visible, y);
    }

    public abstract void updateCustom(boolean var1, int var2);

    public abstract void refresh();

    public boolean canSave() {
        return this.canSave;
    }
}

