/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.render.screen.dialog.ListDialog;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ListWidgetBuilder<T>
extends WidgetBuilder<List<T>> {
    protected final ListBaseEntry<T> config;
    @Nullable
    private Button button;

    public ListWidgetBuilder(AbstractConfigContainer container, ListBaseEntry<T> config) {
        super(container, config);
        this.config = config;
    }

    @Override
    public void addCustomElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
        Minecraft client = (Minecraft)CLIENT.get();
        this.button = Button.builder((Component)TextUtil.literal(String.valueOf(this.config.getValue())), button -> client.setScreen(new ListDialog<T>(client.screen, this.container, this.config))).bounds(x, y, width, height).build();
        appender.accept((AbstractWidget)this.button);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.button == null) {
            return;
        }
        this.button.visible = visible;
        this.button.setY(y);
    }

    @Override
    public void refresh() {
        if (this.button == null) {
            return;
        }
        this.button.setMessage(TextUtil.literal(String.valueOf(this.config.getValue())));
    }
}

