package com.iafenvoy.jupiter;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4013;

public class ConfigManager implements class_4013 {
    private static final ConfigManager INSTANCE = new ConfigManager();

    private final Map<class_2960, AbstractConfigContainer> configHandlers = new HashMap<>();

    public static ConfigManager getInstance() {
        return INSTANCE;
    }

    public void registerConfigHandler(class_2960 id, AbstractConfigContainer handler) {
        this.configHandlers.put(id, handler);
        handler.init();
        handler.load();
    }

    public void registerConfigHandler(AbstractConfigContainer configContainer) {
        this.registerConfigHandler(configContainer.getConfigId(), configContainer);
    }

    public void registerServerConfig(AbstractConfigContainer data, ServerConfigManager.PermissionChecker checker) {
        ServerConfigManager.registerServerConfig(data, checker);
    }

    @Override
    public void method_14491(@NotNull class_3300 manager) {
        this.configHandlers.values().forEach(AbstractConfigContainer::load);
        Jupiter.LOGGER.info("Successfully reload {} common config(s).", this.configHandlers.size());
    }

    public Collection<AbstractConfigContainer> getConfigs() {
        return this.configHandlers.values();
    }
}
