package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerConfigNetwork {
    public static void init() {
        //? >=1.20.5 {
        /*ServerNetworkHelper.INSTANCE.registerReceiver(ConfigRequestPayload.TYPE, (server, player, payload) -> onConfigRequest(server, player, payload.id()));
        ServerNetworkHelper.INSTANCE.registerReceiver(ConfigSyncPayload.TYPE, (server, player, payload) -> onConfigSync(server, player, payload.id(), payload.compound()));
        *///?} else {
        ServerNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_REQUEST_C2S, (server, player, buf) -> onConfigRequest(server, player, buf.method_10810()));
        ServerNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_SYNC_C2S, (server, player, buf) -> onConfigSync(server, player, buf.method_10810(), buf.method_10798()));
        //?}
    }

    private static Runnable onConfigRequest(MinecraftServer server, class_3222 player, class_2960 id) {
        Jupiter.LOGGER.info("Player {} request to get config {}", player.method_5477().getString(), id);
        boolean b = ServerConfigManager.checkPermission(id, server, player, false);
        class_2487 compound;
        if (b) {
            AbstractConfigContainer data = ServerConfigManager.getConfig(id);
            assert data != null;
            compound = data.serializeNbt();
        } else compound = new class_2487();
        //? >=1.20.5 {
        /*return () -> ServerNetworkHelper.INSTANCE.sendToPlayer(player, new ConfigSyncPayload(id, b, compound));
         *///?} else {
        class_2540 buf = ByteBufHelper.create();
        buf.method_10812(id);
        buf.writeBoolean(b);
        buf.method_10794(compound);
        return () -> ServerNetworkHelper.INSTANCE.sendToPlayer(player, NetworkConstants.CONFIG_SYNC_S2C, buf);
        //?}
    }

    private static Runnable onConfigSync(MinecraftServer server, class_3222 player, class_2960 id, class_2487 data) {
        Jupiter.LOGGER.info("Player {} request to change config {}", player.method_5477().getString(), id);
        return () -> {
            if (ServerConfigManager.checkPermission(id, server, player, true)) {
                AbstractConfigContainer container = ServerConfigManager.getConfig(id);
                if (container != null) {
                    Jupiter.LOGGER.info(data.toString());
                    container.deserializeNbt(data);
                    container.onConfigsChanged();
                    Jupiter.LOGGER.info("Player {} changed config {}", player.method_5477().getString(), id);
                }
            } else
                ServerNetworkHelper.INSTANCE.sendToPlayer(player, /*? >=1.20.5 {*//*new ConfigErrorPayload()*//*?} else {*/NetworkConstants.CONFIG_ERROR_S2C, ByteBufHelper.create()/*?}*/);
        };
    }
}
