package com.iafenvoy.jupiter.render.widget;

import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_7842;

public abstract class WidgetBuilder<T> {
    protected static final Supplier<class_310> CLIENT = class_310::method_1551;
    protected final AbstractConfigContainer container;
    protected final IConfigEntry<T> config;
    protected class_7842 textWidget;
    protected class_4185 resetButton;
    protected boolean canSave = true;

    protected WidgetBuilder(AbstractConfigContainer container, IConfigEntry<T> config) {
        this.container = container;
        this.config = config;
    }

    public void addDialogElements(Consumer<class_339> appender, String text, int x, int y, int width, int height) {
        class_327 font = CLIENT.get().field_1772;
        this.textWidget = new class_7842(20, y, font.method_1727(text), height, TextUtil.literal(text), font);
        appender.accept(this.textWidget);
        //? >=1.19.3 {
        this.resetButton = class_4185.method_46430(TextUtil.translatable("jupiter.screen.button.remove"), button -> {
            this.config.reset();
            this.refresh();
        }).method_46434(x + width - 50, y, 50, height).method_46431();
        //?} else {
        /*this.resetButton = new Button(x + width - 50, y, 50, height, TextUtil.translatable("jupiter.screen.button.remove"), button -> {
            this.config.reset();
            this.refresh();
        });
        *///?}
        this.refreshResetButton(true);
        appender.accept(this.resetButton);
        this.addCustomElements(appender, x, y, width - 55, height);
    }

    public void addElements(Consumer<class_339> appender, int x, int y, int width, int height) {
        class_327 font = CLIENT.get().field_1772;
        class_2561 component = TextUtil.literal(this.config.getPrettyName());
        this.textWidget = new class_7842(20, y, font.method_27525(component), height, component, font);
        appender.accept(this.textWidget);
        //? >=1.19.3 {
        this.resetButton = class_4185.method_46430(TextUtil.translatable("jupiter.screen.button.reset"), button -> {
            this.config.reset();
            this.refresh();
        }).method_46434(x + width - 50, y, 50, height).method_46431();
        //?} else {
        /*this.resetButton = new Button(x + width - 50, y, 50, height, TextUtil.translatable("jupiter.screen.button.reset"), button -> {
            this.config.reset();
            this.refresh();
        });
        *///?}
        this.refreshResetButton(false);
        this.config.registerCallback(v -> this.refreshResetButton(false));
        appender.accept(this.resetButton);
        this.addCustomElements(appender, x, y, width - 55, height);
    }

    private void refreshResetButton(boolean dialog) {
        this.setCanReset(dialog || !this.config.getValue().equals(this.config.getDefaultValue()));
    }

    protected void setCanReset(boolean b) {
        this.resetButton.field_22763 = b;
    }

    public abstract void addCustomElements(Consumer<class_339> appender, int x, int y, int width, int height);

    public void update(boolean visible, int y) {
        if (this.textWidget != null) {
            this.textWidget.field_22764 = visible;
            this.textWidget./*? >=1.19.3 {*/method_46419/*?} else {*//*y =*//*?}*/(y);
        }
        if (this.resetButton != null) {
            this.resetButton.field_22764 = visible;
            this.resetButton./*? >=1.19.3 {*/method_46419/*?} else {*//*y =*//*?}*/(y);
        }
        this.updateCustom(visible, y);
    }

    public abstract void updateCustom(boolean visible, int y);

    public abstract void refresh();

    public boolean canSave() {
        return this.canSave;
    }
}
