package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.render.screen.dialog.MapDialog;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;

public class MapWidgetBuilder<T> extends WidgetBuilder<Map<String, T>> {
    protected final MapBaseEntry<T> config;
    @Nullable
    private class_4185 button;

    public MapWidgetBuilder(AbstractConfigContainer container, MapBaseEntry<T> config) {
        super(container, config);
        this.config = config;
    }

    @Override
    public void addCustomElements(Consumer<class_339> appender, int x, int y, int width, int height) {
        class_310 client = CLIENT.get();
        //? >=1.19.3 {
        this.button = class_4185.method_46430(TextUtil.literal(String.valueOf(this.config.getValue())), button -> client.method_1507(new MapDialog<>(client.field_1755, this.container, this.config))).method_46434(x, y, width, height).method_46431();
        //?} else {
        /*this.button = new Button(x, y, width, height, TextUtil.literal(String.valueOf(this.config.getValue())), button -> client.setScreen(new MapDialog<>(client.screen, this.container, this.config)));
         *///?}
        appender.accept(this.button);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.button == null) return;
        this.button.field_22764 = visible;
        this.button./*? >=1.19.3 {*/method_46419/*?} else {*//*y =*//*?}*/(y);
    }

    @Override
    public void refresh() {
        if (this.button == null) return;
        this.button.method_25355(TextUtil.literal(String.valueOf(this.config.getValue())));
    }
}
