package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.datafixers.util.Unit;
import java.util.function.Consumer;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_7842;

public class SeparatorWidgetBuilder extends WidgetBuilder<Unit> {
    public SeparatorWidgetBuilder(AbstractConfigContainer container, IConfigEntry<Unit> config) {
        super(container, config);
    }

    @Override
    public void addElements(Consumer<class_339> appender, int x, int y, int width, int height) {
        class_327 font = CLIENT.get().field_1772;
        width = width + x - 20;
        int w = font.method_1727("-"), k = 0;
        while ((k + 1) * w <= width) k++;
        String name = "-".repeat(k);
        this.textWidget = new class_7842(20, y, font.method_1727(name), height, TextUtil.literal(name), font);
        appender.accept(this.textWidget);
    }

    @Override
    public void addCustomElements(Consumer<class_339> appender, int x, int y, int width, int height) {
        //No Need
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        //No Need
    }

    @Override
    public void refresh() {
        //No Need
    }
}
