package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.interfaces.ITextFieldConfigEntry;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.widget.TextFieldWithErrorWidget;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_339;

public class TextFieldWidgetBuilder<T> extends WidgetBuilder<T> {
    private final ITextFieldConfigEntry textFieldConfig;
    @Nullable
    private TextFieldWithErrorWidget widget;

    public TextFieldWidgetBuilder(AbstractConfigContainer container, IConfigEntry<T> config) {
        super(container, config);
        if (config instanceof ITextFieldConfigEntry t) this.textFieldConfig = t;
        else throw new IllegalArgumentException("TextFieldWidgetBuilder only accept ITextFieldConfigEntry");
    }

    @Override
    public void addCustomElements(Consumer<class_339> appender, int x, int y, int width, int height) {
        this.widget = new TextFieldWithErrorWidget(CLIENT.get().field_1772, x, y, width, height);
        this.widget.method_1852(this.textFieldConfig.valueAsString());
        this.widget.method_1863(s -> {
            try {
                this.textFieldConfig.setValueFromString(s);
                this.canSave = true;
                this.widget.setHasError(false);
            } catch (Exception ignored) {
                this.canSave = false;
                this.widget.setHasError(true);
                this.setCanReset(true);
            }
        });
        appender.accept(this.widget);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.widget == null) return;
        this.widget.field_22764 = visible;
        this.widget./*? >=1.19.3 {*/method_46419/*?} else {*//*y =*//*?}*/(y);
    }

    @Override
    public void refresh() {
        if (this.widget == null) return;
        this.widget.method_1852(this.textFieldConfig.valueAsString());
    }
}
