package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.interfaces.ITextFieldConfigEntry;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.class_2960;

public class ResourceLocationEntry extends BaseEntry<class_2960> implements ITextFieldConfigEntry {
    public ResourceLocationEntry(String nameKey, class_2960 defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public ConfigType<class_2960> getType() {
        return ConfigTypes.RESOURCE_LOCATION;
    }

    @Override
    public IConfigEntry<class_2960> newInstance() {
        return new ResourceLocationEntry(this.nameKey, this.defaultValue).visible(this.visible).json(this.jsonKey);
    }

    @Override
    public Codec<class_2960> getCodec() {
        return class_2960.field_25139;
    }

    @Override
    public String valueAsString() {
        return this.getValue().toString();
    }

    @Override
    public void setValueFromString(String s) {
        this.setValue(Objects.requireNonNull(class_2960.method_12829(s)));
    }
}
