package com.iafenvoy.jupiter.render.widget;

import com.iafenvoy.jupiter.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;

public abstract class WidgetBuilder<T> implements JupiterScreen {
    protected final class_310 minecraft = class_310.method_1551();
    protected final ConfigMetaProvider provider;
    protected final IConfigEntry<T> config;
    protected class_7842 textWidget;
    protected class_4185 resetButton;
    protected boolean canSave = true;

    protected WidgetBuilder(ConfigMetaProvider provider, IConfigEntry<T> config) {
        this.provider = provider;
        this.config = config;
    }

    public void addDialogElements(Context context, String text, int x, int y, int width, int height) {
        class_327 font = this.minecraft.field_1772;
        this.textWidget = new class_7842(20, y, font.method_1727(text), height, TextUtil.literal(text), font);
        context.addWidget(this.textWidget);
        //? >=1.19.3 {
        this.resetButton = class_4185.method_46430(TextUtil.translatable("jupiter.screen.button.remove"), button -> {
            this.config.reset();
            this.refresh();
        }).method_46434(x + width - 50, y, 50, height).method_46431();
        //?} else {
        /*this.resetButton = new Button(x + width - 50, y, 50, height, TextUtil.translatable("jupiter.screen.button.remove"), button -> {
            this.config.reset();
            this.refresh();
        });
        *///?}
        this.refreshResetButton(true);
        context.addWidget(this.resetButton);
        this.addCustomElements(context, x, y, width - 55, height);
    }

    public void addElements(Context context, int x, int y, int width, int height) {
        class_327 font = this.minecraft.field_1772;
        class_2561 component = TextUtil.literal(this.config.getPrettyName());
        this.textWidget = new class_7842(20, y, font.method_27525(component), height, component, font);
        context.addWidget(this.textWidget);
        //? >=1.19.3 {
        this.resetButton = class_4185.method_46430(TextUtil.translatable("jupiter.screen.button.reset"), button -> {
            this.config.reset();
            this.refresh();
        }).method_46434(x + width - 50, y, 50, height).method_46431();
        //?} else {
        /*this.resetButton = new Button(x + width - 50, y, 50, height, TextUtil.translatable("jupiter.screen.button.reset"), button -> {
            this.config.reset();
            this.refresh();
        });
        *///?}
        this.refreshResetButton(false);
        this.config.registerCallback(v -> this.refreshResetButton(false));
        context.addWidget(this.resetButton);
        this.addCustomElements(context, x, y, width - 55, height);
    }

    private void refreshResetButton(boolean dialog) {
        this.setCanReset(dialog || this.config.canReset());
    }

    protected void setCanReset(boolean b) {
        this.resetButton.field_22763 = b;
    }

    public abstract void addCustomElements(Context context, int x, int y, int width, int height);

    public void update(boolean visible, int y) {
        if (this.textWidget != null) {
            this.textWidget.field_22764 = this.textWidget.field_22763 = visible;
            this.textWidget./*? >=1.19.3 {*/method_46419/*?} else {*//*y =*//*?}*/(y);
        }
        if (this.resetButton != null) {
            this.resetButton.field_22764 = visible;
            this.resetButton./*? >=1.19.3 {*/method_46419/*?} else {*//*y =*//*?}*/(y);
        }
        this.updateCustom(visible, y);
    }

    public abstract void updateCustom(boolean visible, int y);

    public abstract void refresh();

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.textWidget.field_22764 && this.textWidget.method_25405(mouseX, mouseY);
    }

    public IConfigEntry<T> getConfig() {
        return this.config;
    }

    public boolean canSave() {
        return this.canSave;
    }

    public record Context(class_437 parent, Consumer<class_339> appender, TitleStack titleStack) {
        public void addWidget(class_339 widget) {
            this.appender.accept(widget);
        }

        public TitleStack push(class_2561 title) {
            return this.titleStack.push(title);
        }
    }
}
