/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.compat.forgeconfigspec;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.entry.BooleanEntry;
import com.iafenvoy.jupiter.config.entry.ConfigGroupEntry;
import com.iafenvoy.jupiter.config.entry.DoubleEntry;
import com.iafenvoy.jupiter.config.entry.EnumEntry;
import com.iafenvoy.jupiter.config.entry.IntegerEntry;
import com.iafenvoy.jupiter.config.entry.ListBooleanEntry;
import com.iafenvoy.jupiter.config.entry.ListDoubleEntry;
import com.iafenvoy.jupiter.config.entry.ListEnumEntry;
import com.iafenvoy.jupiter.config.entry.ListIntegerEntry;
import com.iafenvoy.jupiter.config.entry.ListLongEntry;
import com.iafenvoy.jupiter.config.entry.ListStringEntry;
import com.iafenvoy.jupiter.config.entry.LongEntry;
import com.iafenvoy.jupiter.config.entry.SeparatorEntry;
import com.iafenvoy.jupiter.config.entry.StringEntry;
import com.iafenvoy.jupiter.config.interfaces.ConfigBuilder;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.TextFormatter;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public final class NightConfigHolder {
    private final String modId;
    private final ConfigSide side;
    private final String fileName;
    private final UnmodifiableConfig defaults;
    private final CommentedConfig values;
    private final Runnable save;

    public NightConfigHolder(String modId, ConfigSide side, String fileName, UnmodifiableConfig defaults, CommentedConfig values, Runnable save) {
        this.modId = modId;
        this.side = side;
        this.fileName = fileName;
        this.defaults = defaults;
        this.values = values;
        this.save = save;
    }

    public ResourceLocation id() {
        return Jupiter.id(this.modId, this.side.name().toLowerCase(Locale.ROOT));
    }

    public Component title() {
        return TextUtil.literal(TextFormatter.formatToTitleCase(this.modId + "_" + this.side.name().toLowerCase(Locale.ROOT) + "_config"));
    }

    public ConfigSide getSide() {
        return this.side;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void save() {
        this.save.run();
    }

    public List<ConfigGroup> toGroups() {
        return List.of(this.buildGroup(this.id().toString(), this.title(), this.defaults, this.values));
    }

    public ConfigGroup buildGroup(String id, Component groupName, UnmodifiableConfig defaults, CommentedConfig values) {
        ConfigGroup group = new ConfigGroup(id, groupName);
        for (UnmodifiableConfig.Entry entry : defaults.entrySet()) {
            Object entryValue = entry.getValue();
            Object value = values.get(entry.getKey());
            if (entryValue instanceof ForgeConfigSpec.ValueSpec) {
                ForgeConfigSpec.ValueSpec spec = (ForgeConfigSpec.ValueSpec)entryValue;
                Object defaultValue = spec.getDefault();
                try {
                    String translateKey = Objects.requireNonNullElseGet(spec.getTranslationKey(), () -> ((UnmodifiableConfig.Entry)entry).getKey());
                    ConfigBuilder<?, ?, ?> builder = this.process(values, (Component)TextUtil.translatableWithFallback(translateKey, TextFormatter.formatToTitleCase(translateKey), new Object[0]), entry, defaultValue, value, arg_0 -> ((ForgeConfigSpec.ValueSpec)spec).test(arg_0));
                    if (builder == null) {
                        Jupiter.LOGGER.warn("Cannot find suitable entry for key={}, type={} in config={}:{}", new Object[]{entry.getKey(), defaultValue.getClass().getName(), this.modId, this.side});
                        continue;
                    }
                    if (builder instanceof BaseEntry.Builder) {
                        BaseEntry.Builder baseBuilder = (BaseEntry.Builder)builder;
                        if (spec.getComment() != null) {
                            baseBuilder.tooltip(spec.getComment());
                        }
                    }
                    group.add((IConfigEntry<?>)builder.build());
                }
                catch (Exception e) {
                    Jupiter.LOGGER.error("Cannot load key={}, type={} in config={}:{}", new Object[]{entry.getKey(), defaultValue.getClass().getName(), this.modId, this.side, e});
                }
                continue;
            }
            if (!(entryValue instanceof UnmodifiableConfig)) continue;
            UnmodifiableConfig spec = (UnmodifiableConfig)entryValue;
            if (!(value instanceof CommentedConfig)) continue;
            CommentedConfig config = (CommentedConfig)value;
            MutableComponent name = TextUtil.translatableWithFallback(entry.getKey(), TextFormatter.formatToTitleCase(entry.getKey()), new Object[0]);
            group.add(ConfigGroupEntry.builder((Component)name, this.buildGroup(entry.getKey(), (Component)name, spec, config)).build());
        }
        return group;
    }

    private ConfigBuilder<?, ?, ?> process(CommentedConfig values, Component name, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, Predicate<Object> validator) {
        AtomicReference<Object> holder = new AtomicReference<Object>(null);
        this.processEntry(holder, values, name, entry, defaultValue, value, Boolean.class, BooleanEntry::builder);
        this.processEntry(holder, values, name, entry, defaultValue, value, Integer.class, IntegerEntry::builder);
        this.processEntry(holder, values, name, entry, defaultValue, value, Long.class, LongEntry::builder);
        this.processEntry(holder, values, name, entry, defaultValue, value, Double.class, DoubleEntry::builder);
        this.processEntry(holder, values, name, entry, defaultValue, value, String.class, StringEntry::builder);
        this.processEnum(holder, values, name, entry, defaultValue, value, defaultValue.getClass());
        if (Collection.class.isAssignableFrom(defaultValue.getClass())) {
            if (validator.test(List.of(Boolean.valueOf(false)))) {
                this.processCollectionEntry(holder, values, name, entry, defaultValue, value, ListBooleanEntry::builder);
            } else if (validator.test(List.of(Integer.valueOf(0)))) {
                this.processCollectionEntry(holder, values, name, entry, defaultValue, value, ListIntegerEntry::builder);
            } else if (validator.test(List.of(Long.valueOf(0L)))) {
                this.processCollectionEntry(holder, values, name, entry, defaultValue, value, ListLongEntry::builder);
            } else if (validator.test(List.of(Double.valueOf(0.0)))) {
                this.processCollectionEntry(holder, values, name, entry, defaultValue, value, ListDoubleEntry::builder);
            } else if (validator.test(List.of(""))) {
                this.processCollectionEntry(holder, values, name, entry, defaultValue, value, ListStringEntry::builder);
            } else {
                Optional any = ((List)defaultValue).stream().findAny();
                if (any.isPresent() && any.get().getClass().isEnum()) {
                    this.processEnumCollection(holder, values, name, entry, defaultValue, value, (Enum)any.get());
                } else {
                    Jupiter.LOGGER.warn("Notice: Jupiter cannot resolve empty List<Enum> since technical issue in Java, it is recommended to add a value in default value list.");
                    holder.set(SeparatorEntry.builder().text("jupiter.screen.cannot_process_list_enum").tooltip(name));
                }
            }
        }
        return holder.get();
    }

    private <T extends Enum<T>> void processEnum(AtomicReference<ConfigBuilder<?, ?, ?>> reference, CommentedConfig values, Component name, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, Class<?> clazz) {
        if (clazz.isEnum() && clazz.isAssignableFrom(defaultValue.getClass()) && value instanceof String) {
            String valueStr = (String)value;
            Class<?> testClazz = clazz;
            EnumEntry.Builder<Enum> builder = EnumEntry.builder(name, (Enum)defaultValue);
            ((EnumEntry.Builder)builder.callback((v, r, d) -> values.set(entry.getKey(), (Object)v.name()))).value(Enum.valueOf(testClazz, valueStr));
            reference.set(builder);
        }
    }

    private <T, E extends IConfigEntry<T>, B extends ConfigBuilder<T, E, B>> void processEntry(AtomicReference<ConfigBuilder<?, ?, ?>> reference, CommentedConfig values, Component name, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, Class<T> clazz, BiFunction<Component, T, B> entryProvider) {
        if (clazz.isAssignableFrom(defaultValue.getClass()) && clazz.isAssignableFrom(value.getClass())) {
            ConfigBuilder builder = (ConfigBuilder)entryProvider.apply(name, (Component)defaultValue);
            builder.callback((v, r, d) -> values.set(entry.getKey(), v)).value((Object)value);
            reference.set(builder);
        }
    }

    private <T extends Enum<T>> void processEnumCollection(AtomicReference<ConfigBuilder<?, ?, ?>> reference, CommentedConfig values, Component name, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, T any) {
        Class clazz = any.getDeclaringClass();
        ListEnumEntry.Builder<T> builder = ListEnumEntry.builder(name, (List)defaultValue, any);
        ((ListEnumEntry.Builder)builder.callback((v, r, d) -> values.set(entry.getKey(), v.stream().map(Enum::name).toList()))).value(new LinkedList<Enum>(((List)value).stream().map(x -> Enum.valueOf(clazz, x)).toList()));
        reference.set(builder);
    }

    private <T, E extends IConfigEntry<List<T>>, B extends ConfigBuilder<List<T>, E, B>> void processCollectionEntry(AtomicReference<ConfigBuilder<?, ?, ?>> reference, CommentedConfig values, Component name, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, BiFunction<Component, List<T>, B> entryProvider) {
        ConfigBuilder builder = (ConfigBuilder)entryProvider.apply(name, (List)defaultValue);
        builder.callback((v, r, d) -> values.set(entry.getKey(), v)).value(new LinkedList((List)value));
        reference.set(builder);
    }
}

