/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.ConfigListScreen;
import com.iafenvoy.jupiter.render.screen.scrollbar.HorizontalScrollBar;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class ConfigContainerScreen
extends ConfigListScreen {
    private final Screen parent;
    protected final AbstractConfigContainer container;
    protected final List<TabButton> groupButtons = new ArrayList<TabButton>();
    protected final HorizontalScrollBar groupScrollBar = new HorizontalScrollBar();
    private int currentTab = 0;
    private ConfigGroup currentGroup;

    public ConfigContainerScreen(Screen parent, AbstractConfigContainer container, boolean client) {
        super(parent, TitleStack.create(container.getTitle()), container.getConfigId(), client);
        this.parent = parent;
        this.container = container;
        this.currentGroup = container.getConfigTabs().isEmpty() ? ConfigGroup.EMPTY : container.getConfigTabs().get(0);
        this.topBorder = 60;
    }

    @Override
    protected void m_7856_() {
        this.entries = this.currentGroup.getConfigs();
        super.m_7856_();
        int x = 10;
        int y = 27;
        this.groupButtons.clear();
        List<ConfigGroup> configTabs = this.container.getConfigTabs();
        for (int i = 0; i < configTabs.size(); ++i) {
            ConfigGroup category = configTabs.get(i);
            TabButton tabButton = (TabButton)this.m_142416_((GuiEventListener)new TabButton(category, x, y, this.f_96547_.m_92852_((FormattedText)category.getName()) + 10, 20, button -> {
                this.currentTab = this.container.getConfigTabs().indexOf(button.group);
                this.currentGroup = button.group;
                this.m_232761_();
            }));
            tabButton.f_93623_ = i != this.currentTab;
            this.groupButtons.add(tabButton);
            x += tabButton.m_5711_() + 2;
        }
        this.groupScrollBar.setMaxValue(Math.max(0, (x += 10) - this.f_96543_));
        this.updateTabPos();
    }

    protected void updateTabPos() {
        for (TabButton button : this.groupButtons) {
            button.updatePos(this.groupScrollBar.getValue());
        }
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (super.m_6050_(mouseX, mouseY, scrollY)) {
            return true;
        }
        if (mouseX >= 10.0 && mouseX <= (double)(this.f_96543_ - 20) && mouseY >= 25.0 && mouseY <= 60.0) {
            this.groupScrollBar.setValue(this.groupScrollBar.getValue() + (scrollY > 0.0 ? -20 : 20));
            this.updateTabPos();
            return true;
        }
        return false;
    }

    @Override
    public void m_7379_() {
        this.container.onConfigsChanged();
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    @Override
    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(graphics, mouseX, mouseY, partialTicks);
        this.groupScrollBar.render(graphics, mouseX, mouseY, partialTicks, 10, 50, this.f_96543_ - 20, 8, this.f_96543_ + this.groupScrollBar.getMaxValue());
        if (this.groupScrollBar.isDragging()) {
            this.updateTabPos();
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.groupScrollBar.wasMouseOver()) {
            this.groupScrollBar.setIsDragging(true);
            this.updateTabPos();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.groupScrollBar.setIsDragging(false);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public static class TabButton
    extends Button {
        private final ConfigGroup group;
        private final int baseX;

        public TabButton(ConfigGroup group, int baseX, int y, int width, int height, Consumer<TabButton> listener) {
            super(baseX, y, width, height, group.getName(), button -> listener.accept((TabButton)button));
            this.group = group;
            this.baseX = baseX;
        }

        public void updatePos(int offsetX) {
            this.f_93620_ = this.baseX - offsetX;
        }
    }
}

