/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget;

import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.widget.StringWidget;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class WidgetBuilder<T>
implements JupiterScreen {
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final ConfigMetaProvider provider;
    protected final IConfigEntry<T> config;
    protected StringWidget textWidget;
    protected Button resetButton;
    protected boolean canSave = true;

    protected WidgetBuilder(ConfigMetaProvider provider, IConfigEntry<T> config) {
        this.provider = provider;
        this.config = config;
    }

    public void addDialogElements(Context context, String text, int x, int y, int width, int height) {
        Font font = this.minecraft.f_91062_;
        this.textWidget = new StringWidget(20, y, font.m_92895_(text), height, (Component)TextUtil.literal(text), font);
        context.addWidget(this.textWidget);
        this.resetButton = JupiterScreen.createButton(x + width - 50, y, 50, height, (Component)TextUtil.translatable("jupiter.screen.button.remove", new Object[0]), button -> {
            this.config.reset();
            this.refresh();
        });
        this.refreshResetButton(true);
        context.addWidget((AbstractWidget)this.resetButton);
        this.addCustomElements(context, x, y, width - 55, height);
    }

    public void addElements(Context context, int x, int y, int width, int height) {
        Font font = this.minecraft.f_91062_;
        Component component = this.config.getName();
        this.textWidget = new StringWidget(20, y, font.m_92852_((FormattedText)component), height, component, font);
        context.addWidget(this.textWidget);
        this.resetButton = JupiterScreen.createButton(x + width - 50, y, 50, height, (Component)TextUtil.translatable("jupiter.screen.button.reset", new Object[0]), button -> {
            this.config.reset();
            this.refresh();
        });
        this.refreshResetButton(false);
        this.config.registerCallback((n, r, d) -> this.refreshResetButton(!d));
        context.addWidget((AbstractWidget)this.resetButton);
        this.addCustomElements(context, x, y, width - 55, height);
    }

    private void refreshResetButton(boolean dialog) {
        this.setCanReset(dialog || this.config.canReset());
    }

    protected void setCanReset(boolean b) {
        this.resetButton.f_93623_ = b;
    }

    public abstract void addCustomElements(Context var1, int var2, int var3, int var4, int var5);

    public void update(boolean visible, int y) {
        if (this.textWidget != null) {
            this.textWidget.f_93624_ = this.textWidget.f_93623_ = visible;
            this.textWidget.f_93621_ = y;
        }
        if (this.resetButton != null) {
            this.resetButton.f_93624_ = visible;
            this.resetButton.f_93621_ = y;
        }
        this.updateCustom(visible, y);
    }

    public abstract void updateCustom(boolean var1, int var2);

    public abstract void refresh();

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.textWidget.f_93624_ && this.textWidget.m_5953_(mouseX, mouseY);
    }

    public IConfigEntry<T> getConfig() {
        return this.config;
    }

    public boolean canSave() {
        return this.canSave;
    }

    public record Context(Screen parent, Consumer<AbstractWidget> appender, TitleStack titleStack) {
        public void addWidget(AbstractWidget widget) {
            this.appender.accept(widget);
        }

        public TitleStack push(Component title) {
            return this.titleStack.push(title);
        }
    }
}

