/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.entry.IntegerEntry;
import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.network.chat.Component;

public class ListIntegerEntry
extends ListBaseEntry<Integer> {
    protected ListIntegerEntry(Builder builder) {
        super(builder);
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public ListIntegerEntry(String nameKey, List<Integer> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<Integer> getValueCodec() {
        return Codec.INT;
    }

    @Override
    public IConfigEntry<Integer> newSingleInstance(Integer value, int index, Runnable reload) {
        return ((IntegerEntry.Builder)IntegerEntry.builder(this.name, (int)value).callback((v, r, d) -> {
            if (r) {
                ((List)this.getValue()).remove(index);
                reload.run();
            } else {
                ((List)this.getValue()).set(index, v);
            }
            this.setValue((List)this.getValue());
        })).build();
    }

    @Override
    public Integer newValue() {
        return 0;
    }

    @Override
    public ConfigType<List<Integer>> getType() {
        return ConfigTypes.LIST_INTEGER;
    }

    @Override
    public IConfigEntry<List<Integer>> newInstance() {
        return new Builder(this).build();
    }

    public static Builder builder(Component name, List<Integer> defaultValue) {
        return new Builder(name, defaultValue);
    }

    public static Builder builder(String nameKey, List<Integer> defaultValue) {
        return new Builder(nameKey, defaultValue);
    }

    public static class Builder
    extends BaseEntry.Builder<List<Integer>, ListIntegerEntry, Builder> {
        public Builder(Component name, List<Integer> defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, List<Integer> defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(ListIntegerEntry parent) {
            super(parent);
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        protected ListIntegerEntry buildInternal() {
            return new ListIntegerEntry(this);
        }
    }
}

