/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.interfaces.RangeConfigEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.network.chat.Component;

public class LongEntry
extends BaseEntry<Long>
implements RangeConfigEntry<Long> {
    private final long minValue;
    private final long maxValue;
    private boolean useSlider = false;

    protected LongEntry(Builder builder) {
        super(builder);
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public LongEntry(String nameKey, Long defaultValue) {
        this(nameKey, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public LongEntry(String nameKey, long defaultValue, long minValue, long maxValue) {
        super(nameKey, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public LongEntry slider() {
        if (Long.MIN_VALUE < this.minValue && this.maxValue < Long.MAX_VALUE) {
            this.useSlider = true;
        }
        return this;
    }

    @Override
    public ConfigType<Long> getType() {
        return ConfigTypes.LONG;
    }

    @Override
    public IConfigEntry<Long> newInstance() {
        return new Builder(this).build();
    }

    @Override
    public Codec<Long> getCodec() {
        Function checker = Codec.checkRange((Number)this.minValue, (Number)this.maxValue);
        return Codec.LONG.flatXmap(checker, checker);
    }

    @Override
    public Long getMinValue() {
        return this.minValue;
    }

    @Override
    public Long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean useSlider() {
        return this.useSlider;
    }

    @Override
    public String valueAsString() {
        return String.valueOf(this.getValue());
    }

    @Override
    public void setValueFromString(String s) {
        long d = Long.parseLong(s);
        if (d < this.minValue || d > this.maxValue) {
            throw new IllegalArgumentException();
        }
        this.setValue(d);
    }

    public static Builder builder(Component name, long defaultValue) {
        return new Builder(name, defaultValue);
    }

    public static Builder builder(String nameKey, long defaultValue) {
        return new Builder(nameKey, defaultValue);
    }

    public static class Builder
    extends BaseEntry.Builder<Long, LongEntry, Builder> {
        protected long minValue = Long.MIN_VALUE;
        protected long maxValue = Long.MAX_VALUE;

        public Builder(Component name, long defaultValue) {
            super(name, Long.valueOf(defaultValue));
        }

        public Builder(String nameKey, long defaultValue) {
            super(nameKey, Long.valueOf(defaultValue));
        }

        public Builder(LongEntry parent) {
            super(parent);
            this.minValue = parent.minValue;
            this.maxValue = parent.maxValue;
        }

        public Builder min(long minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder max(long maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder range(long min, long max) {
            this.min(min);
            this.max(max);
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        protected LongEntry buildInternal() {
            return new LongEntry(this);
        }
    }
}

