package com.iafenvoy.jupiter.render.screen.scrollbar;

//? >=1.20 {
import net.minecraft.client.gui.GuiGraphics;
 //?} else {

/*import com.iafenvoy.jupiter.render.JupiterRenderContext;
import com.mojang.blaze3d.vertex.PoseStack;
*///?}
import net.minecraft.util.Mth;

public class VerticalScrollBar {
    protected boolean mouseOver = false;
    protected boolean dragging = false;
    protected boolean renderScrollbarBackground = true;
    protected int currentValue = 0;
    protected int maxValue = 100;
    protected final int backgroundColor = 0x44FFFFFF;
    protected final int foregroundColor = 0xFFFFFFFF;
    protected int dragStartValue = 0;
    protected int dragStartY = 0;

    public VerticalScrollBar setRenderBarBackground(boolean render) {
        this.renderScrollbarBackground = render;
        return this;
    }

    public int getValue() {
        return this.currentValue;
    }

    public void setValue(int value) {
        this.currentValue = Mth.clamp(value, 0, this.maxValue);
    }

    public void offsetValue(int offset) {
        this.setValue(this.currentValue + offset);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = Math.max(0, maxValue);
        this.currentValue = Math.min(this.currentValue, this.maxValue);
    }

    public boolean wasMouseOver() {
        return this.mouseOver;
    }

    public void setIsDragging(boolean isDragging) {
        this.dragging = isDragging;
    }

    public void render(/*? >=1.20 {*/GuiGraphics graphics/*?} else {*//*PoseStack poseStack*//*?}*/, int mouseX, int mouseY, float partialTicks, int x, int y, int width, int height, int totalHeight) {
        //? <=1.19.4 {
        /*JupiterRenderContext graphics = JupiterRenderContext.wrapPoseStack(poseStack);
        *///?}
        if (this.renderScrollbarBackground)
            graphics.fill(x, y, x + width, y + height, this.backgroundColor);
        if (totalHeight > 0) {
            int slideHeight = height - 2;
            float relative = Math.min(1.0F, (float) slideHeight / (float) totalHeight);
            int barHeight = (int) (relative * slideHeight);
            int barTravel = slideHeight - barHeight;
            int barPosition = y + 1 + (this.maxValue > 0 ? (int) ((this.currentValue / (float) this.maxValue) * barTravel) : 0);
            graphics.fill(x + 1, barPosition, x + width - 1, barPosition + barHeight, this.foregroundColor);
            this.mouseOver = mouseX > x && mouseX < x + width && mouseY > barPosition && mouseY < barPosition + barHeight;
            this.handleDrag(mouseY, barTravel);
        }
    }

    public void handleDrag(int mouseY, int barTravel) {
        if (this.dragging) {
            float valuePerPixel = (float) this.maxValue / barTravel;
            this.setValue((int) (this.dragStartValue + ((mouseY - this.dragStartY) * valuePerPixel)));
        } else {
            this.dragStartY = mouseY;
            this.dragStartValue = this.currentValue;
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }
}
