package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.config.interfaces.RangeConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import net.minecraft.class_2561;

public class DoubleEntry extends BaseEntry<Double> implements RangeConfigEntry<Double> {
    private final double minValue, maxValue;
    private boolean useSlider = false;

    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public DoubleEntry(String nameKey, double defaultValue) {
        this(nameKey, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @SuppressWarnings("removal")
    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public DoubleEntry(String nameKey, double defaultValue, double minValue, double maxValue) {
        super(nameKey, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    protected DoubleEntry(com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder builder) {
        super(builder);
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
    }

    public DoubleEntry slider() {
        if (Integer.MIN_VALUE < this.minValue && this.maxValue < Integer.MAX_VALUE)
            this.useSlider = true;
        return this;
    }

    @Override
    public ConfigType<Double> getType() {
        return ConfigTypes.DOUBLE;
    }

    @Override
    public IConfigEntry<Double> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder(this).buildInternal();
    }

    @Override
    public Codec<Double> getCodec() {
        return Codec.doubleRange(this.minValue, this.maxValue);
    }

    @Override
    public Double getMinValue() {
        return this.minValue;
    }

    @Override
    public Double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean useSlider() {
        return this.useSlider;
    }

    @Override
    public String valueAsString() {
        return String.valueOf(this.getValue());
    }

    @Override
    public void setValueFromString(String s) {
        double d = Double.parseDouble(s);
        if (d < this.minValue || d > this.maxValue) throw new IllegalArgumentException();
        this.setValue(d);
    }

    public static com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder builder(class_2561 name, double defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder builder(String nameKey, double defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<Double, DoubleEntry, com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder> {
        protected double minValue = Double.MIN_VALUE, maxValue = Double.MAX_VALUE;

        public Builder(class_2561 name, double defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, double defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(DoubleEntry parent) {
            super(parent);
            this.minValue = parent.minValue;
            this.maxValue = parent.maxValue;
        }

        public com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder min(double minValue) {
            this.minValue = minValue;
            return this;
        }

        public com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder max(double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.DoubleEntry.Builder self() {
            return this;
        }

        @Override
        protected DoubleEntry buildInternal() {
            return new DoubleEntry(this);
        }
    }
}
