package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.ApiStatus;

import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.class_2561;

@ApiStatus.Internal
public class EntryDoubleEntry extends EntryBaseEntry<Double> {
    protected EntryDoubleEntry(com.iafenvoy.jupiter.config.entry.EntryDoubleEntry.Builder builder) {
        super(builder);
    }

    @Override
    public IConfigEntry<Double> newValueInstance() {
        return DoubleEntry.builder(this.name, this.defaultValue.getValue()).buildInternal();
    }

    @Override
    public ConfigType<Map.Entry<String, Double>> getType() {
        return ConfigTypes.ENTRY_DOUBLE;
    }

    @Override
    public IConfigEntry<Map.Entry<String, Double>> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.EntryDoubleEntry.Builder(this).buildInternal();
    }

    @Override
    public Codec<Map.Entry<String, Double>> getCodec() {
        return RecordCodecBuilder.create(i -> i.group(
                Codec.STRING.fieldOf("key").forGetter(Map.Entry::getKey),
                Codec.DOUBLE.fieldOf("value").forGetter(Map.Entry::getValue)
        ).apply(i, AbstractMap.SimpleEntry::new));
    }

    public static com.iafenvoy.jupiter.config.entry.EntryDoubleEntry.Builder builder(class_2561 name, Map.Entry<String, Double> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.EntryDoubleEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.EntryDoubleEntry.Builder builder(String nameKey, Map.Entry<String, Double> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.EntryDoubleEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<Map.Entry<String, Double>, EntryDoubleEntry, com.iafenvoy.jupiter.config.entry.EntryDoubleEntry.Builder> {
        public Builder(class_2561 name, Map.Entry<String, Double> defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, Map.Entry<String, Double> defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(EntryDoubleEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.EntryDoubleEntry.Builder self() {
            return this;
        }

        @Override
        protected EntryDoubleEntry buildInternal() {
            return new EntryDoubleEntry(this);
        }
    }
}
