package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.EnumHelper;
import com.mojang.serialization.Codec;
import net.minecraft.class_2561;

public class EnumEntry<T extends Enum<T>> extends BaseEntry<T> {
    protected EnumEntry(com.iafenvoy.jupiter.config.entry.EnumEntry.Builder<T> builder) {
        super(builder);
    }

    @SuppressWarnings({"unchecked", "removal"})
    @Deprecated(forRemoval = true)
    public EnumEntry(String nameKey, com.iafenvoy.jupiter.interfaces.IConfigEnumEntry defaultValue) {
        this(nameKey, (T) defaultValue);
    }

    @SuppressWarnings("removal")
    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public EnumEntry(String nameKey, T defaultValue) {
        super(nameKey, defaultValue);
    }

    @SuppressWarnings("unchecked")
    @Override
    public ConfigType<T> getType() {
        return (ConfigType<T>) ConfigTypes.ENUM;
    }

    @Override
    public IConfigEntry<T> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.EnumEntry.Builder<>(this).buildInternal();
    }

    @Override
    public Codec<T> getCodec() {
        return EnumHelper.getCodec(this.value);
    }

    public static <T extends Enum<T>> com.iafenvoy.jupiter.config.entry.EnumEntry.Builder<T> builder(class_2561 name, T defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.EnumEntry.Builder<>(name, defaultValue);
    }

    public static <T extends Enum<T>> com.iafenvoy.jupiter.config.entry.EnumEntry.Builder<T> builder(String nameKey, T defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.EnumEntry.Builder<>(nameKey, defaultValue);
    }

    public static class Builder<T extends Enum<T>> extends BaseEntry.Builder<T, EnumEntry<T>, com.iafenvoy.jupiter.config.entry.EnumEntry.Builder<T>> {
        public Builder(class_2561 name, T defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, T defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(EnumEntry<T> parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.EnumEntry.Builder<T> self() {
            return this;
        }

        @Override
        protected EnumEntry<T> buildInternal() {
            return new EnumEntry<>(this);
        }
    }
}
