package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_2561;

public class ListDoubleEntry extends ListBaseEntry<Double> {
    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public ListDoubleEntry(String nameKey, List<Double> defaultValue) {
        super(nameKey, defaultValue);
    }

    protected ListDoubleEntry(com.iafenvoy.jupiter.config.entry.ListDoubleEntry.Builder builder) {
        super(builder);
    }

    @Override
    public Codec<Double> getValueCodec() {
        return Codec.DOUBLE;
    }

    @Override
    public IConfigEntry<Double> newSingleInstance(Double value, int index, Runnable reload) {
        return DoubleEntry.builder(this.name, value).callback((o, n, r, d) -> {
            if (r) {
                this.getValue().remove(index);
                reload.run();
            } else this.getValue().set(index, value);
        }).buildInternal();
    }

    @Override
    public Double newValue() {
        return (double) 0;
    }

    @Override
    public ConfigType<List<Double>> getType() {
        return ConfigTypes.LIST_DOUBLE;
    }

    @Override
    public IConfigEntry<List<Double>> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.ListDoubleEntry.Builder(this).buildInternal();
    }

    public static com.iafenvoy.jupiter.config.entry.ListDoubleEntry.Builder builder(class_2561 name, List<Double> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ListDoubleEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.ListDoubleEntry.Builder builder(String nameKey, List<Double> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ListDoubleEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<List<Double>, ListDoubleEntry, com.iafenvoy.jupiter.config.entry.ListDoubleEntry.Builder> {
        public Builder(class_2561 name, List<Double> defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, List<Double> defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(ListDoubleEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.ListDoubleEntry.Builder self() {
            return this;
        }

        @Override
        protected ListDoubleEntry buildInternal() {
            return new ListDoubleEntry(this);
        }
    }
}
