package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_2561;

public class ListLongEntry extends ListBaseEntry<Long> {
    protected ListLongEntry(com.iafenvoy.jupiter.config.entry.ListLongEntry.Builder builder) {
        super(builder);
    }

    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public ListLongEntry(String nameKey, List<Long> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<Long> getValueCodec() {
        return Codec.LONG;
    }

    @Override
    public IConfigEntry<Long> newSingleInstance(Long value, int index, Runnable reload) {
        return LongEntry.builder(this.name, value).callback((o, n, r, d) -> {
            if (r) {
                this.getValue().remove(index);
                reload.run();
            } else this.getValue().set(index, value);
        }).buildInternal();
    }

    @Override
    public Long newValue() {
        return 0L;
    }

    @Override
    public ConfigType<List<Long>> getType() {
        return ConfigTypes.LIST_LONG;
    }

    @Override
    public IConfigEntry<List<Long>> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.ListLongEntry.Builder(this).buildInternal();
    }

    public static com.iafenvoy.jupiter.config.entry.ListLongEntry.Builder builder(class_2561 name, List<Long> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ListLongEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.ListLongEntry.Builder builder(String nameKey, List<Long> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ListLongEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<List<Long>, ListLongEntry, com.iafenvoy.jupiter.config.entry.ListLongEntry.Builder> {
        public Builder(class_2561 name, List<Long> defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, List<Long> defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(ListLongEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.ListLongEntry.Builder self() {
            return this;
        }

        @Override
        protected ListLongEntry buildInternal() {
            return new ListLongEntry(this);
        }
    }
}
