package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.config.interfaces.TextFieldConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ResourceLocationEntry extends BaseEntry<class_2960> implements TextFieldConfigEntry {
    protected ResourceLocationEntry(com.iafenvoy.jupiter.config.entry.ResourceLocationEntry.Builder builder) {
        super(builder);
    }

    @SuppressWarnings("removal")
    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public ResourceLocationEntry(String nameKey, class_2960 defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public ConfigType<class_2960> getType() {
        return ConfigTypes.RESOURCE_LOCATION;
    }

    @Override
    public IConfigEntry<class_2960> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.ResourceLocationEntry.Builder(this).buildInternal();
    }

    @Override
    public Codec<class_2960> getCodec() {
        return class_2960.field_25139;
    }

    @Override
    public String valueAsString() {
        return this.getValue().toString();
    }

    @Override
    public void setValueFromString(String s) {
        this.setValue(Objects.requireNonNull(class_2960.method_12829(s)));
    }

    public static com.iafenvoy.jupiter.config.entry.ResourceLocationEntry.Builder builder(class_2561 name, class_2960 defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ResourceLocationEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.ResourceLocationEntry.Builder builder(String nameKey, class_2960 defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ResourceLocationEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<class_2960, ResourceLocationEntry, com.iafenvoy.jupiter.config.entry.ResourceLocationEntry.Builder> {
        public Builder(class_2561 name, class_2960 defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, class_2960 defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(ResourceLocationEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.ResourceLocationEntry.Builder self() {
            return this;
        }

        @Override
        protected ResourceLocationEntry buildInternal() {
            return new ResourceLocationEntry(this);
        }
    }
}
