package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.BadgeRenderer;
import com.iafenvoy.jupiter.util.TextUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4280;

@ApiStatus.Internal
public class JupiterConfigListWidget extends class_4280<JupiterConfigListWidget.ConfigEntry> {
    private final JupiterConfigListScreen screen;
    private final List<ConfigEntry> entries = new ArrayList<>();
    private String filter = "";

    public JupiterConfigListWidget(JupiterConfigListScreen screen, class_310 client, int width, int height, int y/*? <=1.20.1 {*//*, int bottom*//*?}*/) {
        super(client, width, height, y,/*? <=1.20.1 {*//*bottom,*//*?}*/ 32);
        this.screen = screen;
        //? <=1.20.1 {
        /*this.setRenderTopAndBottom(false);
        *///?}
    }

    public void update() {
        this.entries.clear();
        ConfigManager.getInstance().getConfigs().forEach(x -> this.entries.add(new ConfigEntry(this.screen, x)));
        this.updateEntries();
    }

    //? >=1.21.4 {
    @Override
    protected int method_65507() {
        return this.method_55442() - 8;
    }
    //?} else if >=1.20.2 {
    /*@Override
    protected int getScrollbarPosition() {
        return this.getRight() - 8;
    }
   *///?} else {
    /*@Override
    protected int getScrollbarPosition() {
        return this.x1 - 8;
    }
    *///?}

    @Override
    public int method_25322() {
        return this.field_22758 - 4;
    }

    @Override
    public void setSelected(@Nullable JupiterConfigListWidget.ConfigEntry selected) {
        super.method_25313(selected);
        this.screen.setOpenConfigState(this.method_25334() != null);
    }

    private void updateEntries() {
        this.method_25339();
        this.entries.stream().filter(x -> x.match(this.filter)).forEach(this::method_25321);
        this.method_44382(0);
    }

    //? >=1.21.9 {
    @Override
    public boolean method_25404(@NotNull class_11908 event) {
        //?} else {
    /*@Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        *///?}
        ConfigEntry entry = this.method_25334();
        //? >=1.21.9 {
        return entry != null && entry.method_25404(event) || super.method_25404(event);
         //?} else {
        /*return entry != null && entry.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        *///?}
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase(Locale.ROOT);
        this.updateEntries();
    }

    public static class ConfigEntry extends class_4280.class_4281<ConfigEntry> {
        private final class_310 client = class_310.method_1551();
        private final JupiterConfigListScreen screen;
        private final AbstractConfigContainer handler;

        public ConfigEntry(JupiterConfigListScreen screen, AbstractConfigContainer handler) {
            this.screen = screen;
            this.handler = handler;
        }

        //? >=1.21.9 {
        @Override
        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            int x = this.method_46426(), y = this.method_46427();
            //?} else >=1.20 {
        /*@Override
        public void render(@NotNull GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            *///?} else {
        /*@Override
        public void render(@NotNull PoseStack poseStack, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            JupiterRenderContext graphics = JupiterRenderContext.wrapPoseStack(poseStack);
            *///?}
            graphics.method_27535(this.client.field_1772, this.handler.getTitle(), x + 65, y + 1, 0xFFFFFFFF);
            graphics.method_25303(this.client.field_1772, this.handler.getConfigId().toString(), x + 65, y + 1 + 9, 0xFF7F7F7F);
            graphics.method_25303(this.client.field_1772, this.handler.getPath(), x + 65, y + 1 + 18, 0xFF7F7F7F);
            //Badges
            ConfigSource source = this.handler.getSource();
            ConfigSide side = this.handler.getSide();
            BadgeRenderer.draw(graphics, this.client.field_1772, x + 1, y + 1, source.name(), source.color());
            BadgeRenderer.draw(graphics, this.client.field_1772, x + 1, y + 16, TextUtil.literal(side.getDisplayText()), side.getColor());
        }

        //? >=1.21.9 {
        @Override
        public boolean method_25402(@NotNull class_11909 event, boolean doubleClicked) {
            //?} else {
        /*@Override
        public boolean mouseClicked(double x, double y, int button) {
            *///?}
            this.screen.select(this);
            return false;
        }

        public AbstractConfigContainer getConfigContainer() {
            return this.handler;
        }

        @Override
        public @NotNull class_2561 method_37006() {
            return TextUtil.empty();
        }

        public boolean match(String filter) {
            return this.handler.getTitle().getString().toLowerCase(Locale.ROOT).contains(filter) ||
                    this.handler.getConfigId().toString().contains(filter) ||
                    this.handler.getPath().contains(filter);
        }
    }
}