package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.config.interfaces.TextFieldConfigEntry;
import com.iafenvoy.jupiter.render.widget.TextFieldWithErrorWidget;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import org.jetbrains.annotations.Nullable;

public class TextFieldWidgetBuilder<T> extends WidgetBuilder<T> {
    private final TextFieldConfigEntry textFieldConfig;
    @Nullable
    private TextFieldWithErrorWidget widget;

    public TextFieldWidgetBuilder(ConfigMetaProvider provider, IConfigEntry<T> config) {
        super(provider, config);
        if (config instanceof TextFieldConfigEntry t) this.textFieldConfig = t;
        else throw new IllegalArgumentException("TextFieldWidgetBuilder only accept ITextFieldConfigEntry");
    }

    @Override
    public void addCustomElements(Context context, int x, int y, int width, int height) {
        this.widget = new TextFieldWithErrorWidget(this.minecraft.field_1772, x, y, width, height);
        this.widget.method_1852(this.textFieldConfig.valueAsString());
        this.widget.method_1863(s -> {
            try {
                this.textFieldConfig.setValueFromString(s);
                this.canSave = true;
                this.widget.setHasError(false);
            } catch (Exception ignored) {
                this.canSave = false;
                this.widget.setHasError(true);
                this.setCanReset(true);
            }
        });
        context.addWidget(this.widget);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.widget == null) return;
        this.widget.field_22764 = visible;
        this.widget./*? >=1.19.3 {*/method_46419/*?} else {*//*y =*//*?}*/(y);
    }

    @Override
    public void refresh() {
        if (this.widget == null) return;
        this.widget.method_1852(this.textFieldConfig.valueAsString());
    }
}
