/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.ConfigListScreen;
import com.iafenvoy.jupiter.render.screen.scrollbar.HorizontalScrollBar;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class ConfigContainerScreen
extends ConfigListScreen {
    protected final AbstractConfigContainer container;
    protected final List<TabButton> groupButtons = new ArrayList<TabButton>();
    protected final HorizontalScrollBar groupScrollBar = new HorizontalScrollBar();
    private int currentTab = 0;
    private ConfigGroup currentGroup;

    public ConfigContainerScreen(class_437 parent, AbstractConfigContainer container, boolean client) {
        super(parent, TitleStack.create(container.getTitle()), container.getConfigId(), client);
        this.container = container;
        this.currentGroup = container.getConfigTabs().isEmpty() ? ConfigGroup.EMPTY : container.getConfigTabs().get(0);
        this.topBorder = 60;
    }

    @Override
    protected void method_25426() {
        this.entries = this.currentGroup.getConfigs();
        super.method_25426();
        int x = 10;
        int y = 27;
        this.groupButtons.clear();
        List<ConfigGroup> configTabs = this.container.getConfigTabs();
        for (int i = 0; i < configTabs.size(); ++i) {
            ConfigGroup category = configTabs.get(i);
            TabButton tabButton = (TabButton)this.method_37063((class_364)new TabButton(category, x, y, this.field_22793.method_27525((class_5348)category.getName()) + 10, 20, button -> {
                this.currentTab = this.container.getConfigTabs().indexOf(button.group);
                this.currentGroup = button.group;
                this.method_41843();
            }));
            tabButton.field_22763 = i != this.currentTab;
            this.groupButtons.add(tabButton);
            x += tabButton.method_25368() + 2;
        }
        this.groupScrollBar.setMaxValue(Math.max(0, (x += 10) - this.field_22789));
        this.updateTabPos();
    }

    protected void updateTabPos() {
        for (TabButton button : this.groupButtons) {
            button.updatePos(this.groupScrollBar.getValue());
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollY)) {
            return true;
        }
        if (mouseX >= 10.0 && mouseX <= (double)(this.field_22789 - 20) && mouseY >= 25.0 && mouseY <= 60.0) {
            this.groupScrollBar.setValue(this.groupScrollBar.getValue() + (scrollY > 0.0 ? -20 : 20));
            this.updateTabPos();
            return true;
        }
        return false;
    }

    @Override
    public void method_25419() {
        this.container.onConfigsChanged();
        super.method_25419();
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.groupScrollBar.render(graphics, mouseX, mouseY, partialTicks, 10, 50, this.field_22789 - 20, 8, this.field_22789 + this.groupScrollBar.getMaxValue());
        if (this.groupScrollBar.isDragging()) {
            this.updateTabPos();
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.groupScrollBar.wasMouseOver()) {
            this.groupScrollBar.setIsDragging(true);
            this.updateTabPos();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.groupScrollBar.setIsDragging(false);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public static class TabButton
    extends class_4185 {
        private final ConfigGroup group;
        private final int baseX;

        public TabButton(ConfigGroup group, int baseX, int y, int width, int height, Consumer<TabButton> listener) {
            super(baseX, y, width, height, group.getName(), button -> listener.accept((TabButton)button), field_40754);
            this.group = group;
            this.baseX = baseX;
        }

        public void updatePos(int offsetX) {
            this.method_46421(this.baseX - offsetX);
        }
    }
}

