/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.compat.forgeconfigspec.ConfigSpecLoader;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConfigManager
implements ResourceManagerReloadListener {
    private static final Map<ResourceLocation, ServerConfigHolder> CONFIGS = new HashMap<ResourceLocation, ServerConfigHolder>();

    public static void registerServerConfig(AbstractConfigContainer data, PermissionChecker checker) {
        ServerConfigManager.registerServerConfig(data, checker, false);
    }

    public static void registerServerConfig(AbstractConfigContainer data, PermissionChecker checker, boolean allowManualSync) {
        CONFIGS.put(data.getConfigId(), new ServerConfigHolder(data, checker, allowManualSync));
    }

    @Nullable
    public static AbstractConfigContainer getConfig(ResourceLocation id) {
        ServerConfigHolder holder = CONFIGS.get(id);
        if (holder == null) {
            return null;
        }
        return holder.data;
    }

    public static boolean checkPermission(ResourceLocation id, MinecraftServer server, ServerPlayer player, boolean modify) {
        ServerConfigHolder holder = CONFIGS.get(id);
        if (holder == null) {
            return false;
        }
        return !modify && holder.allowManualSync || holder.checker.check(server, player);
    }

    public static List<AbstractConfigContainer> getServerConfigs() {
        return CONFIGS.values().stream().map(ServerConfigHolder::data).toList();
    }

    public void onResourceManagerReload(@NotNull ResourceManager manager) {
        CONFIGS.values().forEach(x -> x.data.load());
        ConfigSpecLoader.scanConfig();
        Jupiter.LOGGER.info("Successfully reload {} server config(s).", (Object)CONFIGS.size());
    }

    @FunctionalInterface
    public static interface PermissionChecker {
        public static final PermissionChecker ALWAYS_TRUE = (server, player) -> true;
        public static final PermissionChecker ALWAYS_FALSE = (server, player) -> false;
        public static final PermissionChecker IS_DEDICATE_SERVER = (server, player) -> server.isDedicatedServer();
        public static final PermissionChecker IS_LOCAL_GAME = (server, player) -> !IS_DEDICATE_SERVER.check(server, player);
        public static final PermissionChecker IS_OPERATOR = (server, player) -> IS_LOCAL_GAME.check(server, player) || player.hasPermissions(server.getOperatorUserPermissionLevel());

        public boolean check(MinecraftServer var1, ServerPlayer var2);
    }

    private record ServerConfigHolder(AbstractConfigContainer data, PermissionChecker checker, boolean allowManualSync) {
    }
}

