/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.entry.EnumEntry;
import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.EnumHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.network.chat.Component;

public class ListEnumEntry<T extends Enum<T>>
extends ListBaseEntry<T> {
    private final T example;

    protected ListEnumEntry(Builder<T> builder) {
        super(builder);
        this.example = builder.example;
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public ListEnumEntry(String nameKey, List<T> defaultValue, T example) {
        super(nameKey, defaultValue);
        this.example = example;
    }

    @Override
    public Codec<T> getValueCodec() {
        return EnumHelper.getCodec(this.example);
    }

    @Override
    public IConfigEntry<T> newSingleInstance(T value, int index, Runnable reload) {
        return ((EnumEntry.Builder)EnumEntry.builder(this.name, value).callback((o, n, r, d) -> {
            if (r) {
                ((List)this.getValue()).remove(index);
                reload.run();
            } else {
                ((List)this.getValue()).set(index, value);
            }
        })).buildInternal();
    }

    @Override
    public T newValue() {
        return this.example;
    }

    @Override
    public ConfigType<List<T>> getType() {
        return ConfigTypes.LIST_ENUM;
    }

    @Override
    public IConfigEntry<List<T>> newInstance() {
        return new Builder(this).buildInternal();
    }

    public static <T extends Enum<T>> Builder<T> builder(Component name, List<T> defaultValue, T example) {
        return new Builder<T>(name, defaultValue, example);
    }

    public static <T extends Enum<T>> Builder<T> builder(String nameKey, List<T> defaultValue, T example) {
        return new Builder<T>(nameKey, defaultValue, example);
    }

    public static class Builder<T extends Enum<T>>
    extends BaseEntry.Builder<List<T>, ListEnumEntry<T>, Builder<T>> {
        protected final T example;

        public Builder(Component name, List<T> defaultValue, T example) {
            super(name, defaultValue);
            this.example = example;
        }

        public Builder(String nameKey, List<T> defaultValue, T example) {
            super(nameKey, defaultValue);
            this.example = example;
        }

        public Builder(ListEnumEntry<T> parent) {
            super(parent);
            this.example = parent.example;
        }

        @Override
        public Builder<T> self() {
            return this;
        }

        @Override
        protected ListEnumEntry<T> buildInternal() {
            return new ListEnumEntry(this);
        }
    }
}

