/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.container;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.entry.IntegerEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public abstract class AbstractConfigContainer {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final List<ConfigGroup> configTabs = new ArrayList<ConfigGroup>();
    protected final ResourceLocation id;
    protected final String titleNameKey;
    protected final IntegerEntry version;
    private Codec<List<ConfigGroup>> cache;

    public AbstractConfigContainer(ResourceLocation id, String titleNameKey) {
        this(id, titleNameKey, 0);
    }

    public AbstractConfigContainer(ResourceLocation id, String titleNameKey, int version) {
        this.id = id;
        this.titleNameKey = titleNameKey;
        this.version = new IntegerEntry("version", version);
    }

    public ResourceLocation getConfigId() {
        return this.id;
    }

    public String getTitleNameKey() {
        return this.titleNameKey;
    }

    public ConfigGroup createTab(String id, String translateKey) {
        ConfigGroup category = new ConfigGroup(id, translateKey, new ArrayList());
        this.configTabs.add(category);
        this.cache = null;
        return category;
    }

    public List<ConfigGroup> getConfigTabs() {
        return this.configTabs;
    }

    public final void onConfigsChanged() {
        this.save();
        this.load();
    }

    public abstract void load();

    public abstract void save();

    public abstract void init();

    public String serialize() {
        JsonElement element;
        if (this.cache == null) {
            this.cache = this.buildCodec();
        }
        if ((element = (JsonElement)this.cache.encodeStart((DynamicOps)JsonOps.INSTANCE, this.configTabs).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).orElseThrow()) instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            this.writeCustomData(obj);
        }
        return GSON.toJson(element);
    }

    @Comment(value="For Network Usage Only")
    public CompoundTag serializeNbt() {
        if (this.cache == null) {
            this.cache = this.buildCodec();
        }
        return (CompoundTag)this.cache.encodeStart((DynamicOps)NbtOps.INSTANCE, this.configTabs).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).orElseThrow();
    }

    public void deserialize(String data) {
        JsonElement element = JsonParser.parseString((String)data);
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            if (!this.shouldLoad(obj)) {
                return;
            }
            this.deserializeJson((JsonElement)obj);
            this.readCustomData(obj);
        }
    }

    public final void deserializeJson(JsonElement element) {
        if (this.cache == null) {
            this.cache = this.buildCodec();
        }
        this.cache.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
    }

    @Comment(value="For Network Usage Only")
    public final void deserializeNbt(CompoundTag element) {
        if (element == null) {
            return;
        }
        if (this.cache == null) {
            this.cache = this.buildCodec();
        }
        this.cache.parse((DynamicOps)NbtOps.INSTANCE, (Object)element);
    }

    protected Codec<List<ConfigGroup>> buildCodec() {
        return MapCodec.of((MapEncoder)new MapEncoder.Implementation<List<ConfigGroup>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return AbstractConfigContainer.this.configTabs.stream().map(ConfigGroup::getId).map(arg_0 -> ops.createString(arg_0));
            }

            public <T> RecordBuilder<T> encode(List<ConfigGroup> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return input.stream().reduce(prefix, (p, c) -> p.add(c.getId(), c.encode(ops)), (a, b) -> null);
            }
        }, (MapDecoder)new MapDecoder.Implementation<List<ConfigGroup>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return AbstractConfigContainer.this.configTabs.stream().map(ConfigGroup::getId).map(arg_0 -> ops.createString(arg_0));
            }

            public <T> DataResult<List<ConfigGroup>> decode(DynamicOps<T> ops, MapLike<T> input) {
                input.entries().forEach(x -> {
                    String s = (String)ops.getStringValue(x.getFirst()).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).orElseThrow();
                    AbstractConfigContainer.this.configTabs.stream().filter(y -> y.getId().equals(s)).findFirst().ifPresent(y -> y.decode(ops, x.getSecond()));
                });
                return DataResult.success(AbstractConfigContainer.this.configTabs);
            }
        }).codec();
    }

    @Comment(value="Only call on saving to disk, not on network")
    protected boolean shouldLoad(JsonObject obj) {
        return true;
    }

    @Comment(value="Only call on saving to disk, not on network")
    protected void readCustomData(JsonObject obj) {
    }

    @Comment(value="Only call on saving to disk, not on network")
    protected void writeCustomData(JsonObject obj) {
    }

    public ConfigSource getSource() {
        return ConfigSource.NONE;
    }
}

