/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.entry.EntryBaseEntry;
import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.interfaces.IConfigEnumEntry;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.ButtonWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.EntryWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.ListWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.MapWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.SeparatorWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.TextFieldWidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class WidgetBuilderManager {
    private static final Map<ConfigType<?>, BiFunction<AbstractConfigContainer, IConfigEntry<?>, WidgetBuilder<?>>> BUILDERS = new HashMap();

    public static <T> void register(ConfigType<T> type, BiFunction<AbstractConfigContainer, IConfigEntry<T>, WidgetBuilder<T>> builder) {
        BUILDERS.put(type, builder);
    }

    public static <T> WidgetBuilder<T> get(AbstractConfigContainer container, IConfigEntry<T> entry) {
        return BUILDERS.getOrDefault(entry.getType(), Fallback::new).apply(container, entry);
    }

    static {
        WidgetBuilderManager.register(ConfigTypes.SEPARATOR, SeparatorWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.BOOLEAN, (container, config) -> new ButtonWidgetBuilder((AbstractConfigContainer)container, config, button -> config.setValue((Boolean)config.getValue() == false), () -> TextUtil.literal((Boolean)config.getValue() != false ? "\u00a7atrue" : "\u00a7cfalse")));
        WidgetBuilderManager.register(ConfigTypes.INTEGER, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.DOUBLE, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.STRING, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.ENUM, (container, config) -> new ButtonWidgetBuilder((AbstractConfigContainer)container, config, button -> config.setValue(((IConfigEnumEntry)config.getValue()).cycle(true)), () -> ((IConfigEnumEntry)config.getValue()).getDisplayText()));
        WidgetBuilderManager.register(ConfigTypes.LIST_STRING, (container, config) -> new ListWidgetBuilder((AbstractConfigContainer)container, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_INTEGER, (container, config) -> new ListWidgetBuilder((AbstractConfigContainer)container, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_DOUBLE, (container, config) -> new ListWidgetBuilder((AbstractConfigContainer)container, (ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_STRING, (container, config) -> new MapWidgetBuilder((AbstractConfigContainer)container, (MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_INTEGER, (container, config) -> new MapWidgetBuilder((AbstractConfigContainer)container, (MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_DOUBLE, (container, config) -> new MapWidgetBuilder((AbstractConfigContainer)container, (MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_STRING, (container, config) -> new EntryWidgetBuilder((AbstractConfigContainer)container, (EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_INTEGER, (container, config) -> new EntryWidgetBuilder((AbstractConfigContainer)container, (EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_DOUBLE, (container, config) -> new EntryWidgetBuilder((AbstractConfigContainer)container, (EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.RESOURCE_LOCATION, TextFieldWidgetBuilder::new);
    }

    private static class Fallback<T>
    extends WidgetBuilder<T> {
        public Fallback(AbstractConfigContainer container, IConfigEntry<T> config) {
            super(container, config);
        }

        @Override
        public void addElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
            Font textRenderer = ((Minecraft)Fallback.CLIENT.get()).font;
            Component text = TextUtil.translatable("jupiter.screen.unregistered_widget", this.config.getClass().getSimpleName(), this.resolveModName());
            this.textWidget = new StringWidget(20, y, textRenderer.width((FormattedText)text), height, text, textRenderer);
            appender.accept((AbstractWidget)this.textWidget);
        }

        public String resolveModName() {
            String id = this.container.getConfigId().getNamespace();
            return ModList.get().getModContainerById(id).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse("%ERROR%");
        }

        @Override
        public void addCustomElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
        }

        @Override
        public void updateCustom(boolean visible, int y) {
        }

        @Override
        public void refresh() {
        }
    }
}

