/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen.dialog;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.dialog.Dialog;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class MapDialog<T>
extends Dialog<Map<String, T>> {
    protected final MapBaseEntry<T> entry;
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    protected final List<WidgetBuilder<Map.Entry<String, T>>> widgets = new ArrayList<WidgetBuilder<Map.Entry<String, T>>>();
    private int configPerPage;

    public MapDialog(Screen parent, AbstractConfigContainer container, MapBaseEntry<T> entry) {
        super(parent, container, entry);
        this.entry = entry;
    }

    @Override
    protected void init() {
        super.init();
        int width = Math.max(10, this.width - 70);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)TextUtil.literal("<"), button -> this.onClose()).bounds(10, 5, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)TextUtil.literal("+"), button -> {
            ((Map)this.entry.getValue()).put("", this.entry.newValue());
            this.rebuildWidgets();
        }).bounds(width - 10, 5, 20, 20).build());
        this.calculateMaxItems();
        this.widgets.clear();
        Map values = (Map)this.entry.getValue();
        for (Map.Entry entry : values.entrySet()) {
            WidgetBuilder<Map.Entry<String, T>> widget = WidgetBuilderManager.get(this.container, this.entry.newSingleInstance(entry.getValue(), (String)entry.getKey(), () -> this.rebuildWidgets()));
            this.widgets.add(widget);
            widget.addDialogElements(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            }, "", 10, 0, width, 20);
        }
        this.updateItemPos();
    }

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.height - 30) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, ((Map)this.entry.getValue()).size() - this.configPerPage));
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        Map entries = (Map)this.entry.getValue();
        for (i = 0; i < top && i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < entries.size(); ++i) {
            this.widgets.get(i).update(true, 30 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < entries.size(); ++i) {
            this.widgets.get(i).update(false, 0);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollY)) {
            return true;
        }
        this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (scrollY > 0.0 ? -1 : 1) * 2);
        this.updateItemPos();
        return true;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.itemScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.width - 18, 30, 8, this.height - 50, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.mouseClicked(mouseX, mouseY, button);
        if (!b) {
            this.setFocused(null);
        }
        return b;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.itemScrollBar.setIsDragging(false);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

