/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.interfaces.ITextFieldConfigEntry;
import com.iafenvoy.jupiter.render.widget.TextFieldWithErrorWidget;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.Nullable;

public class TextFieldWidgetBuilder<T>
extends WidgetBuilder<T> {
    private final ITextFieldConfigEntry textFieldConfig;
    @Nullable
    private TextFieldWithErrorWidget widget;

    public TextFieldWidgetBuilder(AbstractConfigContainer container, IConfigEntry<T> config) {
        super(container, config);
        ITextFieldConfigEntry t;
        if (!(config instanceof ITextFieldConfigEntry)) {
            throw new IllegalArgumentException("TextFieldWidgetBuilder only accept ITextFieldConfigEntry");
        }
        this.textFieldConfig = t = (ITextFieldConfigEntry)((Object)config);
    }

    @Override
    public void addCustomElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
        this.widget = new TextFieldWithErrorWidget(((Minecraft)TextFieldWidgetBuilder.CLIENT.get()).font, x, y, width, height);
        this.widget.setValue(this.textFieldConfig.valueAsString());
        this.widget.setResponder(s -> {
            try {
                this.textFieldConfig.setValueFromString((String)s);
                this.canSave = true;
                this.widget.setHasError(false);
            }
            catch (Exception ignored) {
                this.canSave = false;
                this.widget.setHasError(true);
                this.setCanReset(true);
            }
        });
        appender.accept((AbstractWidget)this.widget);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.widget == null) {
            return;
        }
        this.widget.visible = visible;
        this.widget.setY(y);
    }

    @Override
    public void refresh() {
        if (this.widget == null) {
            return;
        }
        this.widget.setValue(this.textFieldConfig.valueAsString());
    }
}

