package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.EnumHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_2561;

public class ListEnumEntry<T extends Enum<T>> extends ListBaseEntry<T> {
    private final T newValue;

    protected ListEnumEntry(com.iafenvoy.jupiter.config.entry.ListEnumEntry.Builder<T> builder) {
        super(builder);
        this.newValue = builder.newValue;
    }

    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public ListEnumEntry(String nameKey, List<T> defaultValue, T newValue) {
        super(nameKey, defaultValue);
        this.newValue = newValue;
    }

    @Override
    public Codec<T> getValueCodec() {
        return EnumHelper.getCodec(this.newValue);
    }

    @Override
    public IConfigEntry<T> newSingleInstance(T value, int index, Runnable reload) {
        return EnumEntry.builder(this.name, value).callback((v, r, d) -> {
            if (r) {
                this.getValue().remove(index);
                reload.run();
            } else this.getValue().set(index, v);
            this.setValue(this.getValue());
        }).buildInternal();
    }

    @Override
    public T newValue() {
        return this.newValue;
    }

    @SuppressWarnings("unchecked")
    @Override
    public ConfigType<List<T>> getType() {
        return (ConfigType<List<T>>) (Object) ConfigTypes.LIST_ENUM;
    }

    @Override
    public IConfigEntry<List<T>> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.ListEnumEntry.Builder<>(this).buildInternal();
    }

    public static <T extends Enum<T>> com.iafenvoy.jupiter.config.entry.ListEnumEntry.Builder<T> builder(class_2561 name, List<T> defaultValue, T newValue) {
        return new com.iafenvoy.jupiter.config.entry.ListEnumEntry.Builder<>(name, defaultValue, newValue);
    }

    public static <T extends Enum<T>> com.iafenvoy.jupiter.config.entry.ListEnumEntry.Builder<T> builder(String nameKey, List<T> defaultValue, T newValue) {
        return new com.iafenvoy.jupiter.config.entry.ListEnumEntry.Builder<>(nameKey, defaultValue, newValue);
    }

    public static class Builder<T extends Enum<T>> extends BaseEntry.Builder<List<T>, ListEnumEntry<T>, com.iafenvoy.jupiter.config.entry.ListEnumEntry.Builder<T>> {
        protected final T newValue;

        public Builder(class_2561 name, List<T> defaultValue, T newValue) {
            super(name, defaultValue);
            this.newValue = newValue;
        }

        public Builder(String nameKey, List<T> defaultValue, T newValue) {
            super(nameKey, defaultValue);
            this.newValue = newValue;
        }

        public Builder(ListEnumEntry<T> parent) {
            super(parent);
            this.newValue = parent.newValue;
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.ListEnumEntry.Builder<T> self() {
            return this;
        }

        @Override
        protected ListEnumEntry<T> buildInternal() {
            return new ListEnumEntry<>(this);
        }
    }
}
