package com.iafenvoy.jupiter.render;

//? <=1.19.4 {
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.iafenvoy.jupiter.util.TextUtil;
//? >=1.19.3 {
import com.mojang.blaze3d.vertex.*;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
//?} else {
/*import com.mojang.math.Matrix4f;
 *///?}

//A backport of GuiGraphics
public class JupiterRenderContext {
    private final class_4587 pose;
    private final class_4597.class_4598 bufferSource;

    private JupiterRenderContext(class_4587 pose, class_4597.class_4598 bufferSource) {
        this.pose = pose;
        this.bufferSource = bufferSource;
    }

    public static JupiterRenderContext wrapPoseStack(class_4587 poseStack) {
        class_310 minecraft = class_310.method_1551();
        return new JupiterRenderContext(poseStack, minecraft.method_22940().method_23000());
    }

    public void flush() {
        RenderSystem.disableDepthTest();
        this.bufferSource.method_22993();
        RenderSystem.enableDepthTest();
    }

    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.fill(minX, minY, maxX, maxY, 0, color);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int z, int color) {
        this.fill(class_1921.method_23593(), minX, minY, maxX, maxY, z, color);
    }

    public void fill(class_1921 renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        Matrix4f matrix4f = this.pose.method_23760().method_23761();
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float) class_5253.class_5254.method_27762(color) / 255.0F;
        float f = (float) class_5253.class_5254.method_27765(color) / 255.0F;
        float f1 = (float) class_5253.class_5254.method_27766(color) / 255.0F;
        float f2 = (float) class_5253.class_5254.method_27767(color) / 255.0F;
        class_4588 consumer = this.bufferSource.getBuffer(renderType);
        consumer.method_22918(matrix4f, (float) minX, (float) minY, (float) z).method_22915(f, f1, f2, f3).method_1344();
        consumer.method_22918(matrix4f, (float) minX, (float) maxY, (float) z).method_22915(f, f1, f2, f3).method_1344();
        consumer.method_22918(matrix4f, (float) maxX, (float) maxY, (float) z).method_22915(f, f1, f2, f3).method_1344();
        consumer.method_22918(matrix4f, (float) maxX, (float) minY, (float) z).method_22915(f, f1, f2, f3).method_1344();
        this.flush();
    }

    public void drawCenteredString(class_327 font, String text, int x, int y, int color) {
        this.drawCenteredString(font, TextUtil.literal(text), x, y, color);
    }

    public void drawCenteredString(class_327 font, class_2561 text, int x, int y, int color) {
        this.drawString(font, text, x - font.method_27525(text) / 2, y, color);
    }

    public void drawString(class_327 font, @NotNull String text, int x, int y, int color) {
        font.method_1720(this.pose, text, x, y, color);
        this.flush();
    }

    public void drawString(class_327 font, class_2561 text, int x, int y, int color) {
        font.method_30881(this.pose, text, x, y, color);
        this.flush();
    }
}
