/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.compat.forgeconfigspec;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.compat.forgeconfigspec.NightConfigHolder;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.wrapper.NightConfigWrapper;
import com.iafenvoy.jupiter.internal.JupiterSettings;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigSpecLoader {
    public static Map<String, EnumMap<ConfigSide, AbstractConfigContainer>> scanConfig() {
        LinkedHashMap<String, EnumMap<ConfigSide, AbstractConfigContainer>> data = new LinkedHashMap<String, EnumMap<ConfigSide, AbstractConfigContainer>>();
        if (!((Boolean)JupiterSettings.INSTANCE.general.loadForgeConfigs.getValue()).booleanValue()) {
            return data;
        }
        Collection configs = ModConfigs.getFileMap().values();
        for (ModConfig config : configs) {
            try {
                IConfigSpec iConfigSpec = config.getSpec();
                if (!(iConfigSpec instanceof ModConfigSpec)) continue;
                ModConfigSpec spec = (ModConfigSpec)iConfigSpec;
                IConfigSpec.ILoadedConfig valueHolder = config.getLoadedConfig();
                if (valueHolder == null) continue;
                ConfigSide type = switch (config.getType()) {
                    default -> throw new MatchException(null, null);
                    case ModConfig.Type.COMMON, ModConfig.Type.STARTUP -> ConfigSide.COMMON;
                    case ModConfig.Type.CLIENT -> ConfigSide.CLIENT;
                    case ModConfig.Type.SERVER -> ConfigSide.SERVER;
                };
                UnmodifiableConfig defaults = spec.getSpec();
                CommentedConfig values = valueHolder.config();
                Runnable saver = () -> ((IConfigSpec.ILoadedConfig)valueHolder).save();
                NightConfigWrapper container = new NightConfigWrapper(new NightConfigHolder(config.getModId(), type, config.getFileName(), defaults, values, saver));
                ConfigManager.getInstance().registerConfigHandler(container);
                if (config.getType() != ModConfig.Type.CLIENT) {
                    ServerConfigManager.registerServerConfig(container, ServerConfigManager.PermissionChecker.IS_OPERATOR, false);
                }
                data.computeIfAbsent(config.getModId(), s -> new EnumMap(ConfigSide.class)).put(type, container);
            }
            catch (Exception e) {
                Jupiter.LOGGER.error("Failed to load config spec {}:{}:", new Object[]{config.getModId(), config.getType().extension(), e});
            }
        }
        Jupiter.LOGGER.info("Config spec loading complete, found {} configs from {} mods.", (Object)data.values().stream().map(EnumMap::size).reduce(0, Integer::sum, Integer::sum), (Object)data.size());
        return data;
    }
}

