/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.entry.EnumEntry;
import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.EnumHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.network.chat.Component;

public class ListEnumEntry<T extends Enum<T>>
extends ListBaseEntry<T> {
    private final T newValue;

    protected ListEnumEntry(Builder<T> builder) {
        super(builder);
        this.newValue = builder.newValue;
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public ListEnumEntry(String nameKey, List<T> defaultValue, T newValue) {
        super(nameKey, defaultValue);
        this.newValue = newValue;
    }

    @Override
    public Codec<T> getValueCodec() {
        return EnumHelper.getCodec(this.newValue);
    }

    @Override
    public IConfigEntry<T> newSingleInstance(T value, int index, Runnable reload) {
        return ((EnumEntry.Builder)EnumEntry.builder(this.name, value).callback((v, r, d) -> {
            if (r) {
                ((List)this.getValue()).remove(index);
                reload.run();
            } else {
                ((List)this.getValue()).set(index, v);
            }
            this.setValue((List)this.getValue());
        })).buildInternal();
    }

    @Override
    public T newValue() {
        return this.newValue;
    }

    @Override
    public ConfigType<List<T>> getType() {
        return ConfigTypes.LIST_ENUM;
    }

    @Override
    public IConfigEntry<List<T>> newInstance() {
        return new Builder(this).buildInternal();
    }

    public static <T extends Enum<T>> Builder<T> builder(Component name, List<T> defaultValue, T newValue) {
        return new Builder<T>(name, defaultValue, newValue);
    }

    public static <T extends Enum<T>> Builder<T> builder(String nameKey, List<T> defaultValue, T newValue) {
        return new Builder<T>(nameKey, defaultValue, newValue);
    }

    public static class Builder<T extends Enum<T>>
    extends BaseEntry.Builder<List<T>, ListEnumEntry<T>, Builder<T>> {
        protected final T newValue;

        public Builder(Component name, List<T> defaultValue, T newValue) {
            super(name, defaultValue);
            this.newValue = newValue;
        }

        public Builder(String nameKey, List<T> defaultValue, T newValue) {
            super(nameKey, defaultValue);
            this.newValue = newValue;
        }

        public Builder(ListEnumEntry<T> parent) {
            super(parent);
            this.newValue = parent.newValue;
        }

        @Override
        public Builder<T> self() {
            return this;
        }

        @Override
        protected ListEnumEntry<T> buildInternal() {
            return new ListEnumEntry(this);
        }
    }
}

