/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.entry.EntryDoubleEntry;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;

public class MapDoubleEntry
extends MapBaseEntry<Double> {
    protected MapDoubleEntry(Builder builder) {
        super(builder);
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public MapDoubleEntry(String nameKey, Map<String, Double> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<Double> getValueCodec() {
        return Codec.DOUBLE;
    }

    @Override
    public IConfigEntry<Map.Entry<String, Double>> newSingleInstance(Double value, String key, Runnable reload) {
        return ((EntryDoubleEntry.Builder)EntryDoubleEntry.builder(this.name, new AbstractMap.SimpleEntry<String, Double>(key, value)).callback((v, r, d) -> {
            if (r) {
                ((Map)this.getValue()).remove(key);
                reload.run();
            } else if (!Objects.equals(key, v.getKey())) {
                ((Map)this.getValue()).remove(key);
                ((Map)this.getValue()).put((String)v.getKey(), (Double)v.getValue());
            } else {
                ((Map)this.getValue()).put(key, (Double)v.getValue());
            }
            this.setValue((Map)this.getValue());
        })).buildInternal();
    }

    @Override
    public Double newValue() {
        return 0.0;
    }

    @Override
    public ConfigType<Map<String, Double>> getType() {
        return ConfigTypes.MAP_DOUBLE;
    }

    @Override
    public IConfigEntry<Map<String, Double>> newInstance() {
        return new Builder(this).buildInternal();
    }

    public static Builder builder(Component name, Map<String, Double> defaultValue) {
        return new Builder(name, defaultValue);
    }

    public static Builder builder(String nameKey, Map<String, Double> defaultValue) {
        return new Builder(nameKey, defaultValue);
    }

    public static class Builder
    extends BaseEntry.Builder<Map<String, Double>, MapDoubleEntry, Builder> {
        public Builder(Component name, Map<String, Double> defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, Map<String, Double> defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(MapDoubleEntry parent) {
            super(parent);
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        protected MapDoubleEntry buildInternal() {
            return new MapDoubleEntry(this);
        }
    }
}

