/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public final class BadgeRenderer {
    public static void draw(GuiGraphics graphics, Font font, int x, int y, Component text, int color) {
        graphics.drawString(font, text, x + 2, y + 2, -1);
        int n = font.width((FormattedText)text) + 3;
        Objects.requireNonNull(font);
        BadgeRenderer.drawFrame(graphics, x, y, n, 9 + 2, color);
    }

    public static void drawFrame(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        BadgeRenderer.fill(graphics, x, y, x + width, y + height, color);
        BadgeRenderer.fill(graphics, x, y, x - 1, y + height, color);
        BadgeRenderer.fill(graphics, x + width, y, x + width + 1, y + height, color);
        BadgeRenderer.fill(graphics, x, y, x + width, y - 1, color);
        BadgeRenderer.fill(graphics, x, y + height, x + width, y + height + 1, color);
    }

    public static void fill(GuiGraphics graphics, int minX, int minY, int maxX, int maxY, int color) {
        graphics.fill(minX, minY, maxX, maxY, color);
    }
}

