package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_2561;

public class ListBooleanEntry extends ListBaseEntry<Boolean> {
    protected ListBooleanEntry(com.iafenvoy.jupiter.config.entry.ListBooleanEntry.Builder builder) {
        super(builder);
    }

    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public ListBooleanEntry(String nameKey, List<Boolean> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<Boolean> getValueCodec() {
        return Codec.BOOL;
    }

    @Override
    public IConfigEntry<Boolean> newSingleInstance(Boolean value, int index, Runnable reload) {
        return BooleanEntry.builder(this.name, value).callback((o, n, r, d) -> {
            if (r) {
                this.getValue().remove(index);
                reload.run();
            } else this.getValue().set(index, value);
        }).buildInternal();
    }

    @Override
    public Boolean newValue() {
        return false;
    }

    @Override
    public ConfigType<List<Boolean>> getType() {
        return ConfigTypes.LIST_BOOLEAN;
    }

    @Override
    public IConfigEntry<List<Boolean>> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.ListBooleanEntry.Builder(this).buildInternal();
    }

    public static com.iafenvoy.jupiter.config.entry.ListBooleanEntry.Builder builder(class_2561 name, List<Boolean> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ListBooleanEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.ListBooleanEntry.Builder builder(String nameKey, List<Boolean> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ListBooleanEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<List<Boolean>, ListBooleanEntry, com.iafenvoy.jupiter.config.entry.ListBooleanEntry.Builder> {
        public Builder(class_2561 name, List<Boolean> defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, List<Boolean> defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(ListBooleanEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.ListBooleanEntry.Builder self() {
            return this;
        }

        @Override
        protected ListBooleanEntry buildInternal() {
            return new ListBooleanEntry(this);
        }
    }
}
