package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.config.interfaces.TextFieldConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import net.minecraft.class_2561;

public class StringEntry extends BaseEntry<String> implements TextFieldConfigEntry {
    protected StringEntry(com.iafenvoy.jupiter.config.entry.StringEntry.Builder builder) {
        super(builder);
    }

    @SuppressWarnings("removal")
    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public StringEntry(String nameKey, String defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public ConfigType<String> getType() {
        return ConfigTypes.STRING;
    }

    @Override
    public IConfigEntry<String> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.StringEntry.Builder(this).buildInternal();
    }

    @Override
    public Codec<String> getCodec() {
        return Codec.STRING;
    }

    @Override
    public String valueAsString() {
        return this.getValue();
    }

    @Override
    public void setValueFromString(String s) {
        this.setValue(s);
    }

    public static com.iafenvoy.jupiter.config.entry.StringEntry.Builder builder(class_2561 name, String defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.StringEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.StringEntry.Builder builder(String nameKey, String defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.StringEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<String, StringEntry, com.iafenvoy.jupiter.config.entry.StringEntry.Builder> {
        public Builder(class_2561 name, String defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, String defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(StringEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.StringEntry.Builder self() {
            return this;
        }

        @Override
        protected StringEntry buildInternal() {
            return new StringEntry(this);
        }
    }
}
