package com.iafenvoy.jupiter.render.screen.dialog;

import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class MapDialog<T> extends Dialog<Map<String, T>> {
    protected final MapBaseEntry<T> entry;
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    protected final List<WidgetBuilder<Map.Entry<String, T>>> widgets = new ArrayList<>();
    private int configPerPage;

    public MapDialog(class_437 parent, TitleStack titleStack, ConfigMetaProvider provider, MapBaseEntry<T> entry) {
        super(parent, titleStack, provider, entry);
        this.entry = entry;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(JupiterScreen.createButton(10, 5, 20, ITEM_HEIGHT, TextUtil.literal("<"), button -> this.method_25419()));
        this.method_37063(JupiterScreen.createButton(this.field_22789 - 80, 5, 20, ITEM_HEIGHT, TextUtil.literal("+"), button -> {
            this.entry.getValue().put("", this.entry.newValue());
            this.method_41843();
        }));
        this.calculateMaxItems();
        this.widgets.clear();
        Map<String, T> values = this.entry.getValue();
        for (Map.Entry<String, T> entry : values.entrySet()) {
            WidgetBuilder<Map.Entry<String, T>> widget = WidgetBuilderManager.get(this.provider, this.entry.newSingleInstance(entry.getValue(), entry.getKey(), this::method_41843));
            this.widgets.add(widget);
            widget.addDialogElements(new WidgetBuilder.Context(this, this::method_37063, this.titleStack), "", 10, 0, Math.max(10, this.field_22789 - 70), ITEM_HEIGHT);
        }
        this.updateItemPos();
    }

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.field_22790 - 30) / (ITEM_HEIGHT + ITEM_SEP));
        this.itemScrollBar.setMaxValue(Math.max(0, this.entry.getValue().size() - this.configPerPage));
    }

    @Override
    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    public void updateItemPos() {
        int top = this.itemScrollBar.getValue();
        Map<String, T> entries = this.entry.getValue();
        for (int i = 0; i < top && i < entries.size(); i++)
            this.widgets.get(i).update(false, 0);
        for (int i = top; i < top + this.configPerPage && i < entries.size(); i++)
            this.widgets.get(i).update(true, 25 + ITEM_SEP + (i - top) * (ITEM_HEIGHT + ITEM_SEP));
        for (int i = top + this.configPerPage; i < entries.size(); i++)
            this.widgets.get(i).update(false, 0);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY,/*? >=1.20.2 {*//*double scrollX,*//*?}*/ double scrollY) {
        if (super.method_25401(mouseX, mouseY,/*? >=1.20.2 {*//*scrollX,*//*?}*/ scrollY)) return true;
        this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (scrollY > 0 ? -1 : 1) * ITEM_PER_SCROLL);
        this.updateItemPos();
        return true;
    }

    @Override
    public void method_25394(@NotNull /*? >=1.20 {*//*GuiGraphics*//*?} else {*/class_4587/*?}*/ graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.itemScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.field_22789 - 18, 30, 8, this.field_22790 - 50, (this.configPerPage + this.itemScrollBar.getMaxValue()) * (ITEM_HEIGHT + ITEM_SEP));
        if (this.itemScrollBar.isDragging()) this.updateItemPos();
    }

    //? >=1.21.9 {
    /*@Override
    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        int button = event.button();
        *///?} else {
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        //?}
        if (button == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.method_25402(/*? >=1.21.9 {*//*event, isDoubleClick*//*?} else {*/mouseX, mouseY, button/*?}*/);
        if (!b) this.method_25395(null);
        return b;
    }

    //? >=1.21.9 {
    /*@Override
    public boolean mouseReleased(MouseButtonEvent event) {
        int button = event.button();
        *///?} else {
    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        //?}
        if (button == 0) this.itemScrollBar.setIsDragging(false);
        return super.method_25406(/*? >=1.21.9 {*//*event*//*?} else {*/mouseX, mouseY, button/*?}*/);
    }
}
