package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

public class ButtonWidgetBuilder<T> extends WidgetBuilder<T> {
    private final class_4185.class_4241 action;
    private final Supplier<class_2561> nameSupplier;
    @Nullable
    private class_4185 button;

    public ButtonWidgetBuilder(ConfigMetaProvider provider, IConfigEntry<T> config, class_4185.class_4241 action, Supplier<class_2561> nameSupplier) {
        super(provider, config);
        this.action = button -> {
            action.onPress(button);
            this.refresh();
        };
        this.nameSupplier = nameSupplier;
    }

    @Override
    public void addCustomElements(Context context, int x, int y, int width, int height) {
        this.button = JupiterScreen.createButton(x, y, width, height, this.nameSupplier.get(), this.action);
        context.addWidget(this.button);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.button == null) return;
        this.button.field_22764 = visible;
        this.button./*? >=1.19.3 {*//*setY*//*?} else {*/field_22761 =/*?}*/(y);
    }

    @Override
    public void refresh() {
        if (this.button == null) return;
        this.button.method_25355(this.nameSupplier.get());
    }
}
