package com.iafenvoy.jupiter._loader.fabric.network;

//? fabric {

import com.iafenvoy.jupiter.network.ClientNetworkHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;

public class ClientNetworkHelperImpl implements ClientNetworkHelper {
    //? >=1.20.5 {
    @Override
    public void sendToServer(class_8710 payload) {
        ClientPlayNetworking.send(payload);
    }

    @Override
    public <T extends class_8710> void registerReceiver(class_8710.class_9154<T> id, ClientNetworkHelper.Handler<T> handler) {
        ClientPlayNetworking.registerGlobalReceiver(id, (payload, ctx) -> {
            Runnable runnable = handler.handle(ctx.client(), payload);
            if (runnable != null) ctx.client().execute(runnable);
        });
    }
    //?} else {
    /*@Override
    public void sendToServer(ResourceLocation id, FriendlyByteBuf buf) {
        ClientPlayNetworking.send(id, buf);
    }

    @Override
    public void registerReceiver(ResourceLocation id, Handler handler) {
        ClientPlayNetworking.registerGlobalReceiver(id, (minecraft, listener, buf, sender) -> minecraft.execute(handler.handle(minecraft, buf)));
    }
    *///?}
}
